-- Generated by WHMCS\Database\Dumper\Database
--
-- Database: i3cloudcoid_whmcs_dev
-- ------------------------------------------------------
-- Server version	5.5.5-10.3.34-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

USE `i3cloudcoid_whmcs_dev`;

--
-- Table structure for table `ProxmoxAddon_CloudInitScript`
--

DROP TABLE IF EXISTS `ProxmoxAddon_CloudInitScript`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_CloudInitScript` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `script` text COLLATE utf8_unicode_ci NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_CloudInitScript`
--

LOCK TABLES `ProxmoxAddon_CloudInitScript` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_CloudInitScript` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_CloudInitScript` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_Commands`
--

DROP TABLE IF EXISTS `ProxmoxAddon_Commands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_Commands` (
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `uuid` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `parent_uuid` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('stopped','running','error','sleeping') COLLATE utf8_unicode_ci DEFAULT 'stopped',
  `action` enum('none','stop','reboot') COLLATE utf8_unicode_ci DEFAULT 'none',
  `params` text COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uuid` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_Commands`
--

LOCK TABLES `ProxmoxAddon_Commands` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_Commands` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_Commands` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_Job`
--

DROP TABLE IF EXISTS `ProxmoxAddon_Job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_Job` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `retry_after` datetime NOT NULL,
  `retry_count` int(10) unsigned NOT NULL,
  `job` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `rel_id` int(10) unsigned DEFAULT NULL,
  `rel_type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_id` int(10) unsigned DEFAULT NULL,
  `status` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `rel_type` (`rel_type`,`rel_id`,`custom_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_Job`
--

LOCK TABLES `ProxmoxAddon_Job` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_Job` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_Job` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_JobLog`
--

DROP TABLE IF EXISTS `ProxmoxAddon_JobLog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_JobLog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` int(10) unsigned NOT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `message` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `additional` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_JobLog`
--

LOCK TABLES `ProxmoxAddon_JobLog` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_JobLog` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_JobLog` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_KeyPair`
--

DROP TABLE IF EXISTS `ProxmoxAddon_KeyPair`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_KeyPair` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `vm_id` int(11) DEFAULT NULL,
  `public` text COLLATE utf8_unicode_ci NOT NULL,
  `private` text COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hosting_id` (`hosting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_KeyPair`
--

LOCK TABLES `ProxmoxAddon_KeyPair` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_KeyPair` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_KeyPair` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_Logger`
--

DROP TABLE IF EXISTS `ProxmoxAddon_Logger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_Logger` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_ref` int(10) unsigned NOT NULL,
  `id_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `level` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime DEFAULT NULL,
  `request` text COLLATE utf8_unicode_ci NOT NULL,
  `response` text COLLATE utf8_unicode_ci NOT NULL,
  `before_vars` text COLLATE utf8_unicode_ci NOT NULL,
  `vars` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_Logger`
--

LOCK TABLES `ProxmoxAddon_Logger` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_Logger` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_Logger` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_ModuleSettings`
--

DROP TABLE IF EXISTS `ProxmoxAddon_ModuleSettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_ModuleSettings` (
  `setting` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`setting`),
  UNIQUE KEY `setting` (`setting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_ModuleSettings`
--

LOCK TABLES `ProxmoxAddon_ModuleSettings` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_ModuleSettings` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_ModuleSettings` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_NodeSetting`
--

DROP TABLE IF EXISTS `ProxmoxAddon_NodeSetting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_NodeSetting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `server_id` int(10) unsigned NOT NULL,
  `node` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `setting` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_NodeSetting`
--

LOCK TABLES `ProxmoxAddon_NodeSetting` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_NodeSetting` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_NodeSetting` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_ProductConfiguration`
--

DROP TABLE IF EXISTS `ProxmoxAddon_ProductConfiguration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_ProductConfiguration` (
  `product_id` int(11) NOT NULL,
  `setting` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`setting`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_ProductConfiguration`
--

LOCK TABLES `ProxmoxAddon_ProductConfiguration` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_ProductConfiguration` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_ProductConfiguration` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_RrdData`
--

DROP TABLE IF EXISTS `ProxmoxAddon_RrdData`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_RrdData` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `vm_id` int(11) NOT NULL,
  `diskread` float NOT NULL DEFAULT 0,
  `diskwrite` float NOT NULL DEFAULT 0,
  `cpu` float NOT NULL DEFAULT 0,
  `maxcpu` float NOT NULL DEFAULT 0,
  `mem` float NOT NULL DEFAULT 0,
  `maxmem` float NOT NULL DEFAULT 0,
  `netin` float NOT NULL DEFAULT 0,
  `netout` float NOT NULL DEFAULT 0,
  `time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`,`hosting_id`,`vm_id`,`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_RrdData`
--

LOCK TABLES `ProxmoxAddon_RrdData` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_RrdData` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_RrdData` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_ServerConfiguration`
--

DROP TABLE IF EXISTS `ProxmoxAddon_ServerConfiguration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_ServerConfiguration` (
  `server_id` int(11) NOT NULL,
  `setting` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`setting`,`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_ServerConfiguration`
--

LOCK TABLES `ProxmoxAddon_ServerConfiguration` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_ServerConfiguration` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_ServerConfiguration` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_ServerGroup`
--

DROP TABLE IF EXISTS `ProxmoxAddon_ServerGroup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_ServerGroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `server_id` int(11) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_ServerGroup`
--

LOCK TABLES `ProxmoxAddon_ServerGroup` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_ServerGroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_ServerGroup` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_ServerGroupItem`
--

DROP TABLE IF EXISTS `ProxmoxAddon_ServerGroupItem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_ServerGroupItem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `node` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `group_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `ProxmoxAddon_ServerGroupItem_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `ProxmoxAddon_ServerGroup` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_ServerGroupItem`
--

LOCK TABLES `ProxmoxAddon_ServerGroupItem` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_ServerGroupItem` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_ServerGroupItem` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_SnapshotJob`
--

DROP TABLE IF EXISTS `ProxmoxAddon_SnapshotJob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_SnapshotJob` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `vm_id` int(11) DEFAULT NULL,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `vmstate` tinyint(1) DEFAULT NULL,
  `period` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `run_every` int(2) DEFAULT NULL,
  `days` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_SnapshotJob`
--

LOCK TABLES `ProxmoxAddon_SnapshotJob` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_SnapshotJob` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_SnapshotJob` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_User`
--

DROP TABLE IF EXISTS `ProxmoxAddon_User`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_User` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `user_id` int(12) DEFAULT NULL,
  `hosting_id` int(12) NOT NULL,
  `username` varchar(360) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(360) COLLATE utf8_unicode_ci NOT NULL,
  `realm` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_User`
--

LOCK TABLES `ProxmoxAddon_User` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_User` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_User` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_VirtualInterface`
--

DROP TABLE IF EXISTS `ProxmoxAddon_VirtualInterface`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_VirtualInterface` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `vn_id` int(11) NOT NULL,
  `vm_id` int(11) NOT NULL,
  `ip` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `ip_long` int(11) NOT NULL,
  `net` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_VirtualInterface`
--

LOCK TABLES `ProxmoxAddon_VirtualInterface` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_VirtualInterface` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_VirtualInterface` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_VirtualNetwork`
--

DROP TABLE IF EXISTS `ProxmoxAddon_VirtualNetwork`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_VirtualNetwork` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `tag` int(11) NOT NULL,
  `pool` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `cidr` int(11) NOT NULL,
  `gateway` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_VirtualNetwork`
--

LOCK TABLES `ProxmoxAddon_VirtualNetwork` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_VirtualNetwork` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_VirtualNetwork` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_Vm`
--

DROP TABLE IF EXISTS `ProxmoxAddon_Vm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_Vm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `node` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `vmid` int(11) NOT NULL,
  `virtualization` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `cores` int(2) DEFAULT 0,
  `sockets` int(2) DEFAULT 0,
  `vcpus` int(2) DEFAULT 0,
  `cpulimit` float DEFAULT 0,
  `cpuunits` int(8) DEFAULT NULL,
  `memory` int(10) NOT NULL,
  `swap` int(10) DEFAULT 0,
  `disk` int(10) NOT NULL,
  `disks` int(12) DEFAULT 0,
  `netin` int(12) DEFAULT 0,
  `netout` int(12) DEFAULT 0,
  `template` int(1) DEFAULT 0,
  `data` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`,`hosting_id`,`vmid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_Vm`
--

LOCK TABLES `ProxmoxAddon_Vm` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_Vm` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_Vm` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `ProxmoxAddon_VmIpAddress`
--

DROP TABLE IF EXISTS `ProxmoxAddon_VmIpAddress`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ProxmoxAddon_VmIpAddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) DEFAULT NULL,
  `server_id` int(11) DEFAULT NULL,
  `vm_id` int(11) DEFAULT NULL,
  `ip` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `mac_address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subnet_mask` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gateway` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cidr` int(6) DEFAULT NULL,
  `trunks` int(11) DEFAULT NULL,
  `tag` int(11) DEFAULT NULL,
  `net` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ProxmoxAddon_VmIpAddress`
--

LOCK TABLES `ProxmoxAddon_VmIpAddress` WRITE;
/*!40000 ALTER TABLE `ProxmoxAddon_VmIpAddress` DISABLE KEYS */;
/*!40000 ALTER TABLE `ProxmoxAddon_VmIpAddress` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `mg_proxmox_addon_ip`
--

DROP TABLE IF EXISTS `mg_proxmox_addon_ip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mg_proxmox_addon_ip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `type` enum('IPv4','IPv6') COLLATE utf8_unicode_ci DEFAULT 'IPv4',
  `mac_address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subnet_mask` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gateway` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cidr` int(6) DEFAULT NULL,
  `sid` int(11) DEFAULT NULL,
  `visualization` enum('Auto','KVM','LXC') COLLATE utf8_unicode_ci DEFAULT 'Auto',
  `last_check` datetime DEFAULT NULL,
  `private` tinyint(1) DEFAULT 0,
  `hosting_id` int(11) DEFAULT 0,
  `trunks` int(11) DEFAULT NULL,
  `tag` int(11) DEFAULT NULL,
  `node` varchar(200) COLLATE utf8_unicode_ci DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mg_proxmox_addon_ip`
--

LOCK TABLES `mg_proxmox_addon_ip` WRITE;
/*!40000 ALTER TABLE `mg_proxmox_addon_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `mg_proxmox_addon_ip` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `mg_proxmox_addon_recovery_vm_list`
--

DROP TABLE IF EXISTS `mg_proxmox_addon_recovery_vm_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mg_proxmox_addon_recovery_vm_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  `vserver_id` int(11) NOT NULL,
  `node` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `vmid` int(11) NOT NULL,
  `virtualization` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `config` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `dns` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mg_proxmox_addon_recovery_vm_list`
--

LOCK TABLES `mg_proxmox_addon_recovery_vm_list` WRITE;
/*!40000 ALTER TABLE `mg_proxmox_addon_recovery_vm_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `mg_proxmox_addon_recovery_vm_list` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `mg_proxmox_addon_tasks`
--

DROP TABLE IF EXISTS `mg_proxmox_addon_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mg_proxmox_addon_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hosting_id` int(11) NOT NULL,
  `upid` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `node` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `vmid` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `start_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mg_proxmox_addon_tasks`
--

LOCK TABLES `mg_proxmox_addon_tasks` WRITE;
/*!40000 ALTER TABLE `mg_proxmox_addon_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `mg_proxmox_addon_tasks` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `mg_proxmox_vmranges`
--

DROP TABLE IF EXISTS `mg_proxmox_vmranges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mg_proxmox_vmranges` (
  `server_id` int(11) NOT NULL,
  `vmid_from` int(11) DEFAULT NULL,
  `vmid_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mg_proxmox_vmranges`
--

LOCK TABLES `mg_proxmox_vmranges` WRITE;
/*!40000 ALTER TABLE `mg_proxmox_vmranges` DISABLE KEYS */;
/*!40000 ALTER TABLE `mg_proxmox_vmranges` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `mod_invoicedata`
--

DROP TABLE IF EXISTS `mod_invoicedata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_invoicedata` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `invoiceid` int(10) NOT NULL,
  `clientsdetails` text COLLATE utf8_unicode_ci NOT NULL,
  `customfields` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_invoicedata`
--

LOCK TABLES `mod_invoicedata` WRITE;
/*!40000 ALTER TABLE `mod_invoicedata` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_invoicedata` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `mod_onlinenic`
--

DROP TABLE IF EXISTS `mod_onlinenic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mod_onlinenic` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `lockstatus` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `domainid` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_onlinenic`
--

LOCK TABLES `mod_onlinenic` WRITE;
/*!40000 ALTER TABLE `mod_onlinenic` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_onlinenic` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `rstheme_themes`
--

DROP TABLE IF EXISTS `rstheme_themes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rstheme_themes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `version` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active_style` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `active_layout` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pages_configuration` text COLLATE utf8_unicode_ci NOT NULL,
  `widgets_configuration` text COLLATE utf8_unicode_ci NOT NULL,
  `widgets_layouts` text COLLATE utf8_unicode_ci NOT NULL,
  `active_widgets_layout` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `settings` text COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rstheme_themes_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rstheme_themes`
--

LOCK TABLES `rstheme_themes` WRITE;
/*!40000 ALTER TABLE `rstheme_themes` DISABLE KEYS */;
INSERT INTO `rstheme_themes` (`id`, `name`, `version`, `active_style`, `active_layout`, `pages_configuration`, `widgets_configuration`, `widgets_layouts`, `active_widgets_layout`, `settings`, `created_at`, `updated_at`) VALUES ('1', 'lagom', '1.6.0', 'default', 'default', '[]', '[]', '{\"default\":\"Default\"}', 'default', '[]', '2022-01-04 13:18:39', '2022-01-04 13:18:39');
/*!40000 ALTER TABLE `rstheme_themes` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `rsthemes_settings`
--

DROP TABLE IF EXISTS `rsthemes_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rsthemes_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_settings`
--

LOCK TABLES `rsthemes_settings` WRITE;
/*!40000 ALTER TABLE `rsthemes_settings` DISABLE KEYS */;
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('1', 'logo_url', '', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('2', 'display_mode_switcher', '0', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('3', 'display_longest_billing_cycle_monthly_price', '0', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('4', 'light_mode_theme', 'default', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('5', 'dark_mode_theme', 'futuristic', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('6', 'auto_recalculate_package_width', '0', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('7', 'package_price_wrap', 'default', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('8', 'hide_nameserver_fields', 'displayed', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES ('9', 'hide_password_fields', 'displayed', '2022-01-04 13:18:34', '2022-01-04 13:18:34');
/*!40000 ALTER TABLE `rsthemes_settings` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `rsthemes_widgets`
--

DROP TABLE IF EXISTS `rsthemes_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rsthemes_widgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_widgets`
--

LOCK TABLES `rsthemes_widgets` WRITE;
/*!40000 ALTER TABLE `rsthemes_widgets` DISABLE KEYS */;
INSERT INTO `rsthemes_widgets` (`id`, `name`, `slug_name`, `label`) VALUES ('1', 'Active Products/Services', 'active-productsservices', 'Produk/Layanan yang Aktif');
INSERT INTO `rsthemes_widgets` (`id`, `name`, `slug_name`, `label`) VALUES ('2', 'Register a New Domain', 'register-a-new-domain', 'Daftar/Beli Domain');
INSERT INTO `rsthemes_widgets` (`id`, `name`, `slug_name`, `label`) VALUES ('3', 'Recent Support Tickets', 'recent-support-tickets', 'Tiket Dukungan Terbaru');
INSERT INTO `rsthemes_widgets` (`id`, `name`, `slug_name`, `label`) VALUES ('4', 'Recent News', 'recent-news', 'Berita Terbaru');
INSERT INTO `rsthemes_widgets` (`id`, `name`, `slug_name`, `label`) VALUES ('11', 'Overdue Invoices', 'overdue-invoices', 'Overdue Invoices');
/*!40000 ALTER TABLE `rsthemes_widgets` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `tblaccounts`
--

DROP TABLE IF EXISTS `tblaccounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tblaccounts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `currency` int(10) NOT NULL,
  `gateway` text COLLATE utf8_unicode_ci NOT NULL,
  `date` datetime DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `amountin` decimal(16,2) NOT NULL DEFAULT 0.00,
  `fees` decimal(16,2) NOT NULL DEFAULT 0.00,
  `amountout` decimal(16,2) NOT NULL DEFAULT 0.00,
  `rate` decimal(10,5) NOT NULL DEFAULT 1.00000,
  `transid` text COLLATE utf8_unicode_ci NOT NULL,
  `invoiceid` int(10) NOT NULL DEFAULT 0,
  `refundid` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `userid` (`userid`),
  KEY `date` (`date`),
  KEY `transid` (`transid`(32))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaccounts`
--

LOCK TABLES `tblaccounts` WRITE;
/*!40000 ALTER TABLE `tblaccounts` DISABLE KEYS */;
INSERT INTO `tblaccounts` (`id`, `userid`, `currency`, `gateway`, `date`, `description`, `amountin`, `fees`, `amountout`, `rate`, `transid`, `invoiceid`, `refundid`) VALUES ('1', '1', '0', 'duitku_linkaja_applink', '2022-01-13 08:57:02', 'Invoice Payment', '13200.00', '0.00', '0.00', '1.00000', 'D7277DFQRPFOMIEPRSTC', '3', '0');
INSERT INTO `tblaccounts` (`id`, `userid`, `currency`, `gateway`, `date`, `description`, `amountin`, `fees`, `amountout`, `rate`, `transid`, `invoiceid`, `refundid`) VALUES ('2', '1', '0', 'duitku_shopeepay_applink', '2022-01-19 10:10:14', 'Invoice Payment', '385700.00', '0.00', '0.00', '1.00000', '', '4', '0');
/*!40000 ALTER TABLE `tblaccounts` ENABLE KEYS */;
UNLOCK TABLES;
--
-- Table structure for table `tblactivitylog`
--

DROP TABLE IF EXISTS `tblactivitylog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tblactivitylog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `user` text COLLATE utf8_unicode_ci NOT NULL,
  `userid` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `admin_id` int(10) unsigned NOT NULL DEFAULT 0,
  `ipaddr` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `user_id` (`user_id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6129 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblactivitylog`
--

LOCK TABLES `tblactivitylog` WRITE;
/*!40000 ALTER TABLE `tblactivitylog` DISABLE KEYS */;
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1', '2022-01-04 12:50:35', 'Updated WHMCS Rewrite Rules: new rules applied.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2', '2022-01-04 12:50:35', 'URI Path Management Setting \"Rewrite Auto Management\" Enabled', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3', '2022-01-04 12:50:35', 'Updated URI Path Mode to: basic', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('4', '2022-01-04 12:55:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('5', '2022-01-04 12:55:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('6', '2022-01-04 12:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('7', '2022-01-04 12:55:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('8', '2022-01-04 12:55:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('9', '2022-01-04 12:55:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('10', '2022-01-04 12:55:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('11', '2022-01-04 12:55:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('12', '2022-01-04 12:55:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('13', '2022-01-04 12:55:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('14', '2022-01-04 12:55:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('15', '2022-01-04 12:55:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('16', '2022-01-04 12:55:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('17', '2022-01-04 12:55:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('18', '2022-01-04 12:55:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('19', '2022-01-04 12:55:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('20', '2022-01-04 12:55:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('21', '2022-01-04 12:55:04', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('22', '2022-01-04 12:55:04', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('23', '2022-01-04 12:55:04', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('24', '2022-01-04 12:55:05', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('25', '2022-01-04 12:55:05', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('26', '2022-01-04 12:55:05', 'Check for Updates Failed: Failed to retrieve latest version: Loading composer repositories with package information\nIn RemoteFilesystem.php line 560:\nThe \"https://releases.whmcs.com/v2/packages.json\" file could not be downloa\nded: allow_url_fopen must be enabled in php.ini (https:// wrapper is disabl\ned in the server configuration by allow_url_fopen=0\nfailed to open stream: no suitable wrapper could be found)\nupdate [--prefer-source] [--prefer-dist] [--dry-run] [--dev] [--no-dev] [--lock] [--no-custom-installers] [--no-autoloader] [--no-scripts] [--no-progress] [--no-suggest] [--with-dependencies] [--with-all-dependencies] [-v|vv|vvv|--verbose] [-o|--optimize-autoloader] [-a|--classmap-authoritative] [--apcu-autoloader] [--ignore-platform-reqs] [--prefer-stable] [--prefer-lowest] [-i|--interactive] [--root-reqs] [--] [<packages>...]\n', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('27', '2022-01-04 12:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('28', '2022-01-04 12:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('29', '2022-01-04 12:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('30', '2022-01-04 12:57:42', 'General Settings Modified. Changes made: Domain Changed from \'http://client.i3cloud.co.id\' to \'https://client.i3cloud.co.id/\'. System URL Changed from \'http://client.i3cloud.co.id/\' to \'https://client.i3cloud.co.id/\'. Enable Translations Disabled. Disable Domain Grace And Redemption Fees Changed from \'\' to \'0\'. Signature Changed. Email Global Header Changed. Email Global Footer Changed. Ticket Email Limit Changed from \'\' to \'10\'. Prevent Email Reopening Disabled. Update Last Reply Timestamp Changed from \'\' to \'always\'. Metric Usage Invoicing Enabled. PDF Paper Size Changed from \'\' to \'A4\'. Sequential Invoice Numbering Disabled. Affiliate Department Changed from \'\' to \'1\'. Captcha Forms Changed from \'\' to \'{\"checkoutCompletion\":false,\"domainChecker\":true,\"registration\":true,\"contactUs\":true,\"submitTicket\":true,\"login\":false}\'. Enable Email Verification Disabled. send Failed Login Whitelist Disabled. Allow Smarty Php Tags Disabled. Log API Authentication Disabled. Email Marketing Require Opt In Disabled. Disable Client Email Preferences Disabled.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('31', '2022-01-04 12:58:22', 'General Settings Modified. Changes made: Disable Session IP Check Enabled.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('32', '2022-01-04 13:12:23', 'General Settings Modified. Changes made: Language Changed from \'english\' to \'indonesia\'.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('33', '2022-01-04 13:16:17', 'General Settings Modified. Changes made: Template Changed from \'twenty-one\' to \'lagom\'.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('34', '2022-01-04 13:18:34', 'Addon Module Activated - RSThemes', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('35', '2022-01-04 13:18:39', 'Addon Module Access Permissions Changed - RSThemes -  Added Role Group(s): Full Administrator.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('36', '2022-01-04 13:24:09', 'General Settings Modified. Changes made: Order Form Template Changed from \'standard_cart\' to \'lagom\'.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('37', '2022-01-04 13:24:27', 'General Settings Modified. Changes made: Enable Email Verification Enabled.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('38', '2022-01-04 13:32:47', 'Admin User \'robot\' with role Full Administrator created', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('39', '2022-01-04 13:33:21', 'Admin Role Duplicated: Full Administrator to log-admin', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('40', '2022-01-04 13:33:25', 'Admin Role Group Modified: \'log-admin\' - Removed Permissions: Sidebar Statistics', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('41', '2022-01-04 13:33:32', 'Admin Role Group Modified: \'Full Administrator\' - System Level Email Notifications Disabled. Removed Permissions: Sidebar Statistics', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('42', '2022-01-04 13:33:48', 'Admin User \'robot\' modified. Changes: Role changed from \'Full Administrator\' to \'log-admin\'', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('43', '2022-01-04 13:41:01', 'Registrar Activated: \'Liquid\'', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('44', '2022-01-04 13:41:11', 'Domain Registrar Modified: \'Liquid\' - \'Username\' set to \'441\'. \'Password\' value modified.', 'rofiq', '0', '0', '1', '182.1.87.105');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('45', '2022-01-04 16:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('46', '2022-01-04 16:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('47', '2022-01-04 16:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('48', '2022-01-04 20:55:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('49', '2022-01-04 20:55:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('50', '2022-01-04 20:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('51', '2022-01-04 20:55:02', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('52', '2022-01-04 20:55:02', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('53', '2022-01-05 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('54', '2022-01-05 00:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('55', '2022-01-05 00:55:02', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('56', '2022-01-05 00:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('57', '2022-01-05 04:55:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('58', '2022-01-05 04:55:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('59', '2022-01-05 04:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('60', '2022-01-05 04:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('61', '2022-01-05 04:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('62', '2022-01-05 08:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('63', '2022-01-05 08:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('64', '2022-01-05 08:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('65', '2022-01-05 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('66', '2022-01-05 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('67', '2022-01-05 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('68', '2022-01-05 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('69', '2022-01-05 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('70', '2022-01-05 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('71', '2022-01-05 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('72', '2022-01-05 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('73', '2022-01-05 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('74', '2022-01-05 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('75', '2022-01-05 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('76', '2022-01-05 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('77', '2022-01-05 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('78', '2022-01-05 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('79', '2022-01-05 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('80', '2022-01-05 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('81', '2022-01-05 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('82', '2022-01-05 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('83', '2022-01-05 09:00:05', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('84', '2022-01-05 09:00:05', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('85', '2022-01-05 09:00:05', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('86', '2022-01-05 09:00:05', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('87', '2022-01-05 09:00:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('88', '2022-01-05 09:00:05', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('89', '2022-01-05 09:00:06', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('90', '2022-01-05 10:30:03', 'Failed Admin Login Attempt - IP: 125.164.234.20', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('91', '2022-01-05 10:32:05', 'Product Group Created: \'Shared Hosting\' - Product Group ID: 1', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('92', '2022-01-05 10:32:42', 'General Settings Modified. Changes made: Maintenance Mode Enabled.', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('93', '2022-01-05 10:36:38', 'Automation Settings Changed. Changes made: DR Auto Delete Inactive Clients changed from \'on\' to \'off\'. DR Auto Delete Inactive Clients Users changed from \'on\' to \'off\'. DR Auto Delete Inactive Clients Months changed from \'\' to \'0\'. Domain Sync Next Due Date changed from \'\' to \'on\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('94', '2022-01-05 10:37:41', 'General Settings Modified. Changes made: System Emails From Email Changed from \'noreply@client.i3cloud.co.id\' to \'mrofiq466@gmail.com\'.', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('95', '2022-01-05 10:40:12', 'General Settings Modified. Changes made: System Emails From Email Changed from \'mrofiq466@gmail.com\' to \'log.i3cloud@gmail.com\'.', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('96', '2022-01-05 10:42:42', 'General Settings Modified. Changes made: Maintenance Mode Disabled.', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('97', '2022-01-05 10:45:16', 'Gateway Module Activated: \'Duitku VA Permata\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('98', '2022-01-05 10:45:29', 'Gateway Module Activated: \'Duitku VA CIMB\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('99', '2022-01-05 10:45:46', 'Gateway Module Activated: \'Duitku VA ATM Bersama\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('100', '2022-01-05 10:46:06', 'Gateway Module Activated: \'Duitku VA MANDIRI Direct\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('101', '2022-01-05 10:46:16', 'Gateway Module Activated: \'Duitku VA BNI\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('102', '2022-01-05 10:46:56', 'Gateway Module Activated: \'Duitku ShopeePay Applink\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('103', '2022-01-05 10:47:01', 'Gateway Module Activated: \'Duitku QRIS by ShopeePay\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('104', '2022-01-05 10:47:14', 'Gateway Module Activated: \'Duitku LinkAja Applink\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('105', '2022-01-05 10:47:20', 'Gateway Module Activated: \'Duitku LinkAja QRIS\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('106', '2022-01-05 10:47:27', 'Gateway Module Activated: \'Duitku DANA\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('107', '2022-01-05 10:47:32', 'Gateway Module Activated: \'Duitku Ovo\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('108', '2022-01-05 10:49:57', 'Product Created - \'test\' - Product ID: 1', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('109', '2022-01-05 10:50:15', 'Product Configuration Modified: Payment Type Modified: \'free\' to \'recurring\'. Pricing Modified. Product ID: 1', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('110', '2022-01-05 10:52:01', 'Currency Added: \'USD\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('111', '2022-01-05 10:53:24', 'Currency Added: \'IR\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('112', '2022-01-05 10:53:30', 'Currency Deleted: \'IR\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('113', '2022-01-05 10:55:20', 'Gateway Module Configuration Modified: \'Duitku VA Permata\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('114', '2022-01-05 10:55:30', 'Gateway Module Configuration Modified: \'Duitku VA CIMB\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('115', '2022-01-05 10:55:39', 'Gateway Module Configuration Modified: \'Duitku VA ATM Bersama\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('116', '2022-01-05 10:55:47', 'Gateway Module Configuration Modified: \'Duitku VA MANDIRI Direct\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('117', '2022-01-05 10:55:53', 'Gateway Module Configuration Modified: \'Duitku VA BNI\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('118', '2022-01-05 10:55:59', 'Gateway Module Configuration Modified: \'Duitku ShopeePay Applink\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('119', '2022-01-05 10:56:07', 'Gateway Module Configuration Modified: \'Duitku QRIS by ShopeePay\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('120', '2022-01-05 10:56:12', 'Gateway Module Configuration Modified: \'Duitku LinkAja Applink\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('121', '2022-01-05 10:56:20', 'Gateway Module Configuration Modified: \'Duitku LinkAja QRIS\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('122', '2022-01-05 10:56:26', 'Gateway Module Configuration Modified: \'Duitku DANA\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('123', '2022-01-05 10:56:32', 'Gateway Module Configuration Modified: \'Duitku Ovo\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('124', '2022-01-05 10:56:51', 'Gateway Module Configuration Modified: \'Duitku VA MANDIRI Direct\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('125', '2022-01-05 10:57:01', 'Gateway Module Configuration Modified: \'Duitku VA ATM Bersama\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('126', '2022-01-05 10:57:31', 'Gateway Module Configuration Modified: \'Duitku Ovo\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('127', '2022-01-05 10:57:36', 'Gateway Module Configuration Modified: \'Duitku DANA\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('128', '2022-01-05 10:57:42', 'Gateway Module Configuration Modified: \'Duitku LinkAja QRIS\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('129', '2022-01-05 10:57:49', 'Gateway Module Configuration Modified: \'Duitku LinkAja Applink\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('130', '2022-01-05 10:57:55', 'Gateway Module Configuration Modified: \'Duitku QRIS by ShopeePay\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('131', '2022-01-05 10:58:01', 'Gateway Module Configuration Modified: \'Duitku ShopeePay Applink\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('132', '2022-01-05 10:58:43', 'General Settings Modified. Changes made: Default Nameserver1 Changed from \'ns1.client.i3cloud.co.id\' to \'ns1.i3cloud.co.id\'. Default Nameserver2 Changed from \'ns2.client.i3cloud.co.id\' to \'ns2.i3cloud.co.id\'.', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('133', '2022-01-05 11:02:38', 'General Settings Modified. Changes made: Generate Random Username Enabled.', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('134', '2022-01-05 11:03:50', 'General Settings Modified. Changes made: System Emails From Email Changed from \'log.i3cloud@gmail.com\' to \'mrofiq466@gmail.com\'.', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('135', '2022-01-05 11:08:03', 'Domain Registrar Modified: \'Liquid\' - \'Username\' changed from \'441\' to \'11511\'. \'Password\' value modified.', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('136', '2022-01-05 11:11:37', 'General Settings Modified. Changes made: Maintenance Mode Enabled.', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('137', '2022-01-05 11:13:25', 'Tax Configuration: Tax EUHome Country Disabled. Tax Auto Reset Numbering Disabled. Tax Auto Reset Paid Numbering Disabled. Tax IDDisabled Enabled.', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('138', '2022-01-05 11:15:03', 'Tax Configuration: Tax VATEnabled Enabled.', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('139', '2022-01-05 11:17:26', 'Tax Configuration: Tax Per Line Item Disabled.', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('140', '2022-01-05 11:17:48', 'Tax Configuration: Level 1 Rule Added: VAT_INDO', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('141', '2022-01-05 11:18:06', 'Tax Configuration: Level 1 Rule Deleted: VAT_INDO', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('142', '2022-01-05 11:18:20', 'Tax Configuration: Level 1 Rule Added: VAT_INDO', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('143', '2022-01-05 11:23:48', 'Domain Pricing Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('144', '2022-01-05 11:29:09', 'Domain Pricing Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('145', '2022-01-05 11:29:40', 'Domain Pricing Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('146', '2022-01-05 11:32:04', 'Domain Pricing Modified: \'.id\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('147', '2022-01-05 11:35:13', 'Currency Modified: \'IDR\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('148', '2022-01-05 11:35:22', 'Currency Modified: \'USD\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('149', '2022-01-05 11:44:05', 'Currency Modified: \'USD\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('150', '2022-01-05 11:44:11', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('151', '2022-01-05 11:44:14', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('152', '2022-01-05 11:46:10', 'Currency Modified: \'USD\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('153', '2022-01-05 11:46:21', 'Currency Modified: \'USD\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('154', '2022-01-05 11:46:22', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('155', '2022-01-05 11:46:25', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('156', '2022-01-05 11:48:44', 'Currency Modified: \'IDR\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('157', '2022-01-05 11:48:52', 'Currency Modified: \'USD\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('158', '2022-01-05 11:48:55', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('159', '2022-01-05 11:48:57', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('160', '2022-01-05 11:52:53', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('161', '2022-01-05 11:52:55', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('162', '2022-01-05 11:54:14', 'Domain Pricing Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('163', '2022-01-05 11:54:48', 'Domain Pricing Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('164', '2022-01-05 11:56:06', 'Domain Pricing Modified: \'.id\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('165', '2022-01-05 11:56:44', 'Domain Pricing Modified: \'.com\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('166', '2022-01-05 11:57:23', 'Domain Pricing Modified: \'.net\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('167', '2022-01-05 11:57:48', 'Domain Pricing Modified: \'.sch.id\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('168', '2022-01-05 11:59:37', 'Currency Modified: \'USD\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('169', '2022-01-05 11:59:39', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('170', '2022-01-05 11:59:42', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('171', '2022-01-05 12:00:26', 'Currency Modified: \'IDR\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('172', '2022-01-05 12:00:29', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('173', '2022-01-05 12:00:32', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('174', '2022-01-05 12:02:29', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('175', '2022-01-05 12:02:32', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('176', '2022-01-05 12:05:54', 'Currency Modified: \'IDR\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('177', '2022-01-05 12:08:12', 'Automation Settings Changed. Changes made: Currency Auto Update Product Prices changed from \'off\' to \'on\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('178', '2022-01-05 12:11:13', 'Domain Pricing Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('179', '2022-01-05 12:12:25', 'Domain Pricing Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('180', '2022-01-05 12:12:44', 'Automation Settings Changed. Changes made: Currency Auto Update Product Prices changed from \'on\' to \'off\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('181', '2022-01-05 12:12:55', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('182', '2022-01-05 12:12:57', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('183', '2022-01-05 12:13:31', 'Domain Pricing Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('184', '2022-01-05 12:13:49', 'Domain Pricing Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('185', '2022-01-05 12:14:10', 'Domain Pricing Modified: \'.id\'', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('186', '2022-01-05 12:14:23', 'Domain Pricing Modified: \'.com\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('187', '2022-01-05 12:14:35', 'Domain Pricing Modified: \'.net\'', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('188', '2022-01-05 12:14:50', 'Domain Pricing Modified: \'.sch.id\'', 'rofiq', '0', '0', '1', '180.248.5.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('189', '2022-01-05 12:15:25', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('190', '2022-01-05 12:15:28', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '125.164.234.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('191', '2022-01-05 12:32:44', 'General Settings Modified. Changes made: System Emails From Email Changed from \'mrofiq466@gmail.com\' to \'log.i3cloud@gmail.com\'. Sequential Invoice Numbering Disabled.', 'rofiq', '0', '0', '1', '125.166.9.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('192', '2022-01-05 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('193', '2022-01-05 12:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('194', '2022-01-05 12:55:02', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('195', '2022-01-05 12:55:02', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('196', '2022-01-05 16:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('197', '2022-01-05 16:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('198', '2022-01-05 16:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('199', '2022-01-05 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('200', '2022-01-05 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('201', '2022-01-05 20:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('202', '2022-01-05 20:55:02', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('203', '2022-01-05 20:55:02', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('204', '2022-01-06 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('205', '2022-01-06 00:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('206', '2022-01-06 00:55:02', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('207', '2022-01-06 00:55:02', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('208', '2022-01-06 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('209', '2022-01-06 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('210', '2022-01-06 04:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('211', '2022-01-06 04:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('212', '2022-01-06 04:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('213', '2022-01-06 07:14:21', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('214', '2022-01-06 07:14:21', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('215', '2022-01-06 07:14:22', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('216', '2022-01-06 07:14:22', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('217', '2022-01-06 07:14:22', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('218', '2022-01-06 07:14:22', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('219', '2022-01-06 07:14:22', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('220', '2022-01-06 07:14:22', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('221', '2022-01-06 07:14:22', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('222', '2022-01-06 07:14:22', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('223', '2022-01-06 07:14:22', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('224', '2022-01-06 07:14:22', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('225', '2022-01-06 07:14:22', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('226', '2022-01-06 07:14:22', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('227', '2022-01-06 07:14:22', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('228', '2022-01-06 07:14:22', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('229', '2022-01-06 07:14:22', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('230', '2022-01-06 07:14:22', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('231', '2022-01-06 07:14:22', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('232', '2022-01-06 07:14:22', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('233', '2022-01-06 07:14:22', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('234', '2022-01-06 07:14:22', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('235', '2022-01-06 07:14:22', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('236', '2022-01-06 07:14:22', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('237', '2022-01-06 07:14:22', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('238', '2022-01-06 07:14:22', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('239', '2022-01-06 07:14:22', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('240', '2022-01-06 07:14:22', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('241', '2022-01-06 07:14:23', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('242', '2022-01-06 07:14:23', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('243', '2022-01-06 07:14:23', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('244', '2022-01-06 07:14:23', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('245', '2022-01-06 07:14:23', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('246', '2022-01-06 07:14:23', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('247', '2022-01-06 07:14:23', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('248', '2022-01-06 07:14:23', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('249', '2022-01-06 07:14:23', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('250', '2022-01-06 07:14:23', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('251', '2022-01-06 07:14:23', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('252', '2022-01-06 07:14:23', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('253', '2022-01-06 07:15:20', 'General Settings Modified. Changes made: Display Errors Enabled.', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('254', '2022-01-06 07:15:27', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('255', '2022-01-06 07:15:28', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('256', '2022-01-06 07:15:29', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('257', '2022-01-06 07:15:29', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('258', '2022-01-06 07:15:29', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('259', '2022-01-06 07:15:29', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('260', '2022-01-06 07:15:29', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('261', '2022-01-06 07:15:29', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('262', '2022-01-06 07:15:29', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('263', '2022-01-06 07:15:29', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('264', '2022-01-06 07:15:29', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('265', '2022-01-06 07:15:29', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('266', '2022-01-06 07:15:29', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('267', '2022-01-06 07:15:29', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('268', '2022-01-06 07:15:29', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('269', '2022-01-06 07:15:29', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('270', '2022-01-06 07:15:29', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('271', '2022-01-06 07:15:29', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('272', '2022-01-06 07:15:29', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('273', '2022-01-06 07:15:29', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('274', '2022-01-06 07:15:29', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('275', '2022-01-06 07:15:29', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('276', '2022-01-06 07:15:29', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('277', '2022-01-06 07:15:29', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('278', '2022-01-06 07:15:29', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('279', '2022-01-06 07:15:29', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('280', '2022-01-06 07:15:29', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('281', '2022-01-06 07:15:29', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('282', '2022-01-06 07:15:29', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('283', '2022-01-06 07:15:29', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('284', '2022-01-06 07:15:30', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('285', '2022-01-06 07:15:30', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('286', '2022-01-06 07:15:30', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('287', '2022-01-06 07:15:30', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('288', '2022-01-06 07:15:30', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('289', '2022-01-06 07:15:30', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('290', '2022-01-06 07:15:30', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('291', '2022-01-06 07:15:30', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('292', '2022-01-06 07:15:30', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('293', '2022-01-06 07:15:30', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('294', '2022-01-06 07:15:35', 'General Settings Modified. Changes made: Display Errors Disabled.', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('295', '2022-01-06 07:17:55', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('296', '2022-01-06 07:17:55', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('297', '2022-01-06 07:17:56', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('298', '2022-01-06 07:17:56', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('299', '2022-01-06 07:17:56', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('300', '2022-01-06 07:17:56', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('301', '2022-01-06 07:17:56', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('302', '2022-01-06 07:17:56', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('303', '2022-01-06 07:17:56', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('304', '2022-01-06 07:17:56', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('305', '2022-01-06 07:17:56', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('306', '2022-01-06 07:17:56', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('307', '2022-01-06 07:17:56', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('308', '2022-01-06 07:17:56', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('309', '2022-01-06 07:17:56', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('310', '2022-01-06 07:17:56', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('311', '2022-01-06 07:17:56', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('312', '2022-01-06 07:17:56', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('313', '2022-01-06 07:17:56', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('314', '2022-01-06 07:17:56', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('315', '2022-01-06 07:17:56', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('316', '2022-01-06 07:17:56', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('317', '2022-01-06 07:17:56', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('318', '2022-01-06 07:17:56', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('319', '2022-01-06 07:17:56', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('320', '2022-01-06 07:17:56', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('321', '2022-01-06 07:17:56', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('322', '2022-01-06 07:17:56', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('323', '2022-01-06 07:17:56', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('324', '2022-01-06 07:17:56', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('325', '2022-01-06 07:17:56', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('326', '2022-01-06 07:17:56', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('327', '2022-01-06 07:17:56', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('328', '2022-01-06 07:17:56', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('329', '2022-01-06 07:17:56', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('330', '2022-01-06 07:17:56', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('331', '2022-01-06 07:17:56', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('332', '2022-01-06 07:17:56', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('333', '2022-01-06 07:17:56', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('334', '2022-01-06 07:17:57', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('335', '2022-01-06 07:19:58', 'General Settings Modified. Changes made: System Emails From Email Changed from \'log.i3cloud@gmail.com\' to \'noreply@i3cloud.co.id\'.', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('336', '2022-01-06 07:20:04', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('337', '2022-01-06 07:20:05', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('338', '2022-01-06 07:20:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('339', '2022-01-06 07:20:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('340', '2022-01-06 07:20:06', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('341', '2022-01-06 07:20:06', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('342', '2022-01-06 07:20:06', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('343', '2022-01-06 07:20:06', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('344', '2022-01-06 07:20:06', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('345', '2022-01-06 07:20:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('346', '2022-01-06 07:20:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('347', '2022-01-06 07:20:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('348', '2022-01-06 07:20:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('349', '2022-01-06 07:20:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('350', '2022-01-06 07:20:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('351', '2022-01-06 07:20:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('352', '2022-01-06 07:20:06', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('353', '2022-01-06 07:20:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('354', '2022-01-06 07:20:06', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('355', '2022-01-06 07:20:06', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('356', '2022-01-06 07:20:06', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('357', '2022-01-06 07:20:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('358', '2022-01-06 07:20:06', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('359', '2022-01-06 07:20:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('360', '2022-01-06 07:20:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('361', '2022-01-06 07:20:06', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('362', '2022-01-06 07:20:06', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('363', '2022-01-06 07:20:06', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('364', '2022-01-06 07:20:06', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('365', '2022-01-06 07:20:06', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('366', '2022-01-06 07:20:06', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('367', '2022-01-06 07:20:06', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('368', '2022-01-06 07:20:06', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('369', '2022-01-06 07:20:06', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('370', '2022-01-06 07:20:06', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('371', '2022-01-06 07:20:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('372', '2022-01-06 07:20:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('373', '2022-01-06 07:20:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('374', '2022-01-06 07:20:06', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('375', '2022-01-06 07:20:07', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('376', '2022-01-06 07:20:49', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('377', '2022-01-06 07:20:50', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('378', '2022-01-06 07:20:51', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('379', '2022-01-06 07:20:51', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('380', '2022-01-06 07:20:51', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('381', '2022-01-06 07:20:51', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('382', '2022-01-06 07:20:51', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('383', '2022-01-06 07:20:51', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('384', '2022-01-06 07:20:51', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('385', '2022-01-06 07:20:51', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('386', '2022-01-06 07:20:51', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('387', '2022-01-06 07:20:51', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('388', '2022-01-06 07:20:51', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('389', '2022-01-06 07:20:51', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('390', '2022-01-06 07:20:51', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('391', '2022-01-06 07:20:51', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('392', '2022-01-06 07:20:51', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('393', '2022-01-06 07:20:51', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('394', '2022-01-06 07:20:51', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('395', '2022-01-06 07:20:51', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('396', '2022-01-06 07:20:51', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('397', '2022-01-06 07:20:51', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('398', '2022-01-06 07:20:51', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('399', '2022-01-06 07:20:51', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('400', '2022-01-06 07:20:51', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('401', '2022-01-06 07:20:51', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('402', '2022-01-06 07:20:51', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('403', '2022-01-06 07:20:51', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('404', '2022-01-06 07:20:51', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('405', '2022-01-06 07:20:51', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('406', '2022-01-06 07:20:51', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('407', '2022-01-06 07:20:51', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('408', '2022-01-06 07:20:51', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('409', '2022-01-06 07:20:51', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('410', '2022-01-06 07:20:51', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('411', '2022-01-06 07:20:51', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('412', '2022-01-06 07:20:51', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('413', '2022-01-06 07:20:51', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('414', '2022-01-06 07:20:52', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('415', '2022-01-06 07:20:52', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('416', '2022-01-06 07:22:43', 'General Settings Modified. Changes made: System Emails From Email Changed from \'noreply@i3cloud.co.id\' to \'log.i3cloud@gmail.com\'.', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('417', '2022-01-06 07:22:53', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('418', '2022-01-06 07:22:53', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('419', '2022-01-06 07:22:54', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('420', '2022-01-06 07:22:54', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('421', '2022-01-06 07:22:54', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('422', '2022-01-06 07:22:54', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('423', '2022-01-06 07:22:54', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('424', '2022-01-06 07:22:54', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('425', '2022-01-06 07:22:54', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('426', '2022-01-06 07:22:54', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('427', '2022-01-06 07:22:54', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('428', '2022-01-06 07:22:54', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('429', '2022-01-06 07:22:54', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('430', '2022-01-06 07:22:54', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('431', '2022-01-06 07:22:54', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('432', '2022-01-06 07:22:54', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('433', '2022-01-06 07:22:54', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('434', '2022-01-06 07:22:54', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('435', '2022-01-06 07:22:54', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('436', '2022-01-06 07:22:54', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('437', '2022-01-06 07:22:54', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('438', '2022-01-06 07:22:54', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('439', '2022-01-06 07:22:54', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('440', '2022-01-06 07:22:54', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('441', '2022-01-06 07:22:54', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('442', '2022-01-06 07:22:54', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('443', '2022-01-06 07:22:55', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('444', '2022-01-06 07:22:55', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('445', '2022-01-06 07:22:55', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('446', '2022-01-06 07:22:55', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('447', '2022-01-06 07:22:55', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('448', '2022-01-06 07:22:55', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('449', '2022-01-06 07:22:55', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('450', '2022-01-06 07:22:55', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('451', '2022-01-06 07:22:55', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('452', '2022-01-06 07:22:55', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('453', '2022-01-06 07:22:55', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('454', '2022-01-06 07:22:55', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('455', '2022-01-06 07:22:55', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('456', '2022-01-06 07:22:55', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('457', '2022-01-06 07:31:07', 'Server Created: \'Server Singapure\' - Server ID: 1', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('458', '2022-01-06 07:37:23', 'Product Deleted: \'test\' - Product Group ID: 1', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('459', '2022-01-06 07:37:38', 'Product Created - \'NEWBIE\' - Product ID: 2', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('460', '2022-01-06 07:40:16', 'Product Configuration Modified: Product Description Modified. Payment Type Modified: \'free\' to \'recurring\'. WHM Package Name Value Modified: \'\' to \'Powered\'. Pricing Modified. Product ID: 2', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('461', '2022-01-06 07:40:24', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('462', '2022-01-06 07:40:27', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('463', '2022-01-06 07:41:17', 'Product Created - \'REGULAR\' - Product ID: 3', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('464', '2022-01-06 07:43:45', 'Product Configuration Modified: Product Description Modified. Payment Type Modified: \'free\' to \'recurring\'. Automatic Setup Modified: \'\' to \'Payment\'. WHM Package Name Value Modified: \'\' to \'Powered\'. Pricing Modified. Product ID: 3', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('465', '2022-01-06 07:44:01', 'Product Configuration Modified: Automatic Setup Modified: \'\' to \'Payment\'. Product ID: 2', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('466', '2022-01-06 07:44:23', 'Product Created - \'PRO\' - Product ID: 4', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('467', '2022-01-06 07:45:31', 'Product Configuration Modified: Product Description Modified. Payment Type Modified: \'free\' to \'recurring\'. Automatic Setup Modified: \'\' to \'Payment\'. WHM Package Name Value Modified: \'\' to \'Powered\'. Pricing Modified. Product ID: 4', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('468', '2022-01-06 07:46:04', 'Product Created - \'1065000.00\' - Product ID: 5', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('469', '2022-01-06 07:47:27', 'Product Modified - Name Modified: \'1065000.00\' to \'EXCLUSIVE\' - Product ID: 5', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('470', '2022-01-06 07:47:27', 'Product Configuration Modified: Payment Type Modified: \'free\' to \'recurring\'. Automatic Setup Modified: \'\' to \'Payment\'. WHM Package Name Value Modified: \'\' to \'Powered\'. Pricing Modified. Product ID: 5', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('471', '2022-01-06 07:49:31', 'Product Configuration Modified: Product Description Modified. Product ID: 5', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('472', '2022-01-06 07:49:53', 'Manual Mass Product Pricing Update Initiated using Currency Exchange Rates', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('473', '2022-01-06 07:49:56', 'Manual Currency Exchange Rates Sync Initiated', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('474', '2022-01-06 07:52:21', 'Domain Pricing Options Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('475', '2022-01-06 07:52:21', 'Domain Pricing Options Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('476', '2022-01-06 07:52:21', 'Domain Pricing Options Modified: \'.id\'', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('477', '2022-01-06 07:52:21', 'Domain Pricing Options Modified: \'.com\'', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('478', '2022-01-06 07:52:21', 'Domain Pricing Options Modified: \'.net\'', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('479', '2022-01-06 07:52:21', 'Domain Pricing Options Modified: \'.sch.id\'', 'rofiq', '0', '0', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('480', '2022-01-06 07:55:59', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('481', '2022-01-06 07:56:00', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('482', '2022-01-06 07:56:00', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('483', '2022-01-06 07:56:00', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('484', '2022-01-06 07:56:00', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('485', '2022-01-06 07:56:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('486', '2022-01-06 07:56:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('487', '2022-01-06 07:56:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('488', '2022-01-06 07:56:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('489', '2022-01-06 07:56:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('490', '2022-01-06 07:56:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('491', '2022-01-06 07:56:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('492', '2022-01-06 07:56:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('493', '2022-01-06 07:56:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('494', '2022-01-06 07:56:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('495', '2022-01-06 07:56:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('496', '2022-01-06 07:56:06', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('497', '2022-01-06 07:56:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('498', '2022-01-06 07:56:06', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('499', '2022-01-06 07:56:06', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('500', '2022-01-06 07:56:06', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('501', '2022-01-06 07:56:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('502', '2022-01-06 07:56:06', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('503', '2022-01-06 07:56:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('504', '2022-01-06 07:56:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('505', '2022-01-06 07:56:06', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('506', '2022-01-06 07:56:06', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('507', '2022-01-06 07:56:06', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('508', '2022-01-06 07:56:06', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('509', '2022-01-06 07:56:06', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('510', '2022-01-06 07:56:06', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('511', '2022-01-06 07:56:06', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('512', '2022-01-06 07:56:06', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('513', '2022-01-06 07:56:06', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('514', '2022-01-06 07:56:06', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('515', '2022-01-06 07:56:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('516', '2022-01-06 07:56:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('517', '2022-01-06 07:56:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('518', '2022-01-06 07:56:06', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('519', '2022-01-06 07:56:07', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('520', '2022-01-06 07:58:49', 'Created Client Muhammad Rofiq - User ID: 1', 'rofiq', '1', '1', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('521', '2022-01-06 07:58:49', 'Opted In to Marketing Emails - User ID: 1', 'rofiq', '1', '1', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('522', '2022-01-06 07:58:50', 'Email Sent to Muhammad Rofiq (Welcome)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('523', '2022-01-06 07:58:57', 'Verification Email Resent', 'rofiq', '0', '1', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('524', '2022-01-06 08:00:23', 'General Settings Modified. Changes made: Maintenance Mode Disabled.', 'rofiq', '0', '1', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('525', '2022-01-06 08:14:55', 'Verification Email Resent', 'rofiq', '0', '1', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('526', '2022-01-06 08:16:57', 'Created Client Muhammad Rofiq - User ID: 2', 'rofiq', '2', '2', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('527', '2022-01-06 08:16:57', 'Opted In to Marketing Emails - User ID: 2', 'rofiq', '2', '2', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('528', '2022-01-06 08:16:57', 'Email Sent to Muhammad Rofiq (Welcome)  - User ID: 2', 'rofiq', '2', '2', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('529', '2022-01-06 08:17:05', 'Verification Email Resent', 'rofiq', '0', '2', '1', '182.1.93.165');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('530', '2022-01-06 08:55:02', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('531', '2022-01-06 08:55:02', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('532', '2022-01-06 08:55:02', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('533', '2022-01-06 09:00:05', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('534', '2022-01-06 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('535', '2022-01-06 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('536', '2022-01-06 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('537', '2022-01-06 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('538', '2022-01-06 09:00:06', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('539', '2022-01-06 09:00:06', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('540', '2022-01-06 09:00:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('541', '2022-01-06 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('542', '2022-01-06 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('543', '2022-01-06 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('544', '2022-01-06 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('545', '2022-01-06 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('546', '2022-01-06 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('547', '2022-01-06 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('548', '2022-01-06 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('549', '2022-01-06 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('550', '2022-01-06 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('551', '2022-01-06 09:00:06', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('552', '2022-01-06 09:00:06', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('553', '2022-01-06 09:00:06', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('554', '2022-01-06 09:00:06', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('555', '2022-01-06 09:00:06', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('556', '2022-01-06 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('557', '2022-01-06 12:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('558', '2022-01-06 12:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('559', '2022-01-06 12:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('560', '2022-01-06 16:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('561', '2022-01-06 16:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('562', '2022-01-06 16:55:04', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('563', '2022-01-06 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('564', '2022-01-06 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('565', '2022-01-06 20:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('566', '2022-01-06 20:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('567', '2022-01-06 20:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('568', '2022-01-07 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('569', '2022-01-07 00:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('570', '2022-01-07 00:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('571', '2022-01-07 00:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('572', '2022-01-07 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('573', '2022-01-07 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('574', '2022-01-07 04:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('575', '2022-01-07 04:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('576', '2022-01-07 04:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('577', '2022-01-07 08:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('578', '2022-01-07 08:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('579', '2022-01-07 08:55:04', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('580', '2022-01-07 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('581', '2022-01-07 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('582', '2022-01-07 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('583', '2022-01-07 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('584', '2022-01-07 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('585', '2022-01-07 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('586', '2022-01-07 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('587', '2022-01-07 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('588', '2022-01-07 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('589', '2022-01-07 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('590', '2022-01-07 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('591', '2022-01-07 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('592', '2022-01-07 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('593', '2022-01-07 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('594', '2022-01-07 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('595', '2022-01-07 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('596', '2022-01-07 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('597', '2022-01-07 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('598', '2022-01-07 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('599', '2022-01-07 09:00:05', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('600', '2022-01-07 09:00:05', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('601', '2022-01-07 09:00:05', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('602', '2022-01-07 09:00:05', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('603', '2022-01-07 09:00:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('604', '2022-01-07 09:00:05', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('605', '2022-01-07 09:00:06', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('606', '2022-01-07 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('607', '2022-01-07 12:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('608', '2022-01-07 12:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('609', '2022-01-07 12:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('610', '2022-01-07 16:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('611', '2022-01-07 16:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('612', '2022-01-07 16:55:04', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('613', '2022-01-07 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('614', '2022-01-07 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('615', '2022-01-07 20:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('616', '2022-01-07 20:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('617', '2022-01-07 20:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('618', '2022-01-08 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('619', '2022-01-08 00:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('620', '2022-01-08 00:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('621', '2022-01-08 00:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('622', '2022-01-08 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('623', '2022-01-08 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('624', '2022-01-08 04:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('625', '2022-01-08 04:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('626', '2022-01-08 04:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('627', '2022-01-08 08:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('628', '2022-01-08 08:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('629', '2022-01-08 08:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('630', '2022-01-08 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('631', '2022-01-08 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('632', '2022-01-08 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('633', '2022-01-08 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('634', '2022-01-08 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('635', '2022-01-08 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('636', '2022-01-08 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('637', '2022-01-08 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('638', '2022-01-08 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('639', '2022-01-08 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('640', '2022-01-08 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('641', '2022-01-08 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('642', '2022-01-08 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('643', '2022-01-08 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('644', '2022-01-08 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('645', '2022-01-08 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('646', '2022-01-08 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('647', '2022-01-08 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('648', '2022-01-08 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('649', '2022-01-08 09:00:05', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('650', '2022-01-08 09:00:05', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('651', '2022-01-08 09:00:05', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('652', '2022-01-08 09:00:06', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('653', '2022-01-08 09:00:06', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('654', '2022-01-08 09:00:06', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('655', '2022-01-08 09:00:07', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('656', '2022-01-08 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('657', '2022-01-08 12:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('658', '2022-01-08 12:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('659', '2022-01-08 12:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('660', '2022-01-08 16:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('661', '2022-01-08 16:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('662', '2022-01-08 16:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('663', '2022-01-08 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('664', '2022-01-08 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('665', '2022-01-08 20:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('666', '2022-01-08 20:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('667', '2022-01-08 20:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('668', '2022-01-09 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('669', '2022-01-09 00:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('670', '2022-01-09 00:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('671', '2022-01-09 00:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('672', '2022-01-09 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('673', '2022-01-09 01:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('674', '2022-01-09 04:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('675', '2022-01-09 04:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('676', '2022-01-09 04:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('677', '2022-01-09 08:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('678', '2022-01-09 08:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('679', '2022-01-09 08:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('680', '2022-01-09 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('681', '2022-01-09 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('682', '2022-01-09 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('683', '2022-01-09 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('684', '2022-01-09 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('685', '2022-01-09 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('686', '2022-01-09 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('687', '2022-01-09 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('688', '2022-01-09 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('689', '2022-01-09 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('690', '2022-01-09 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('691', '2022-01-09 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('692', '2022-01-09 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('693', '2022-01-09 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('694', '2022-01-09 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('695', '2022-01-09 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('696', '2022-01-09 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('697', '2022-01-09 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('698', '2022-01-09 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('699', '2022-01-09 09:00:06', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('700', '2022-01-09 09:00:06', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('701', '2022-01-09 09:00:06', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('702', '2022-01-09 09:00:06', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('703', '2022-01-09 09:00:06', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('704', '2022-01-09 09:00:06', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('705', '2022-01-09 09:00:07', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('706', '2022-01-09 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('707', '2022-01-09 12:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('708', '2022-01-09 12:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('709', '2022-01-09 12:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('710', '2022-01-09 16:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('711', '2022-01-09 16:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('712', '2022-01-09 16:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('713', '2022-01-09 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('714', '2022-01-09 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('715', '2022-01-09 20:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('716', '2022-01-09 20:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('717', '2022-01-09 20:55:03', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('718', '2022-01-10 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('719', '2022-01-10 00:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('720', '2022-01-10 00:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('721', '2022-01-10 00:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('722', '2022-01-10 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('723', '2022-01-10 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('724', '2022-01-10 03:25:00', 'Failed Admin Login Attempt - IP: 182.1.70.166', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('725', '2022-01-10 03:37:03', 'Server Created: \'Server Indonesia\' - Server ID: 2', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('726', '2022-01-10 03:42:14', 'Server Group Created: \'ns2.i3cloud.co.id\' - Server Group ID: 1', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('727', '2022-01-10 03:42:50', 'Product Configuration Modified: Server Group Modified: \'0\' to \'1\'. WHM Package Name Value Modified: \'Powered\' to \'newbie\'. Product ID: 2', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('728', '2022-01-10 03:43:45', 'Product Configuration Modified: Server Group Modified: \'0\' to \'1\'. WHM Package Name Value Modified: \'Powered\' to \'regular\'. Product ID: 3', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('729', '2022-01-10 03:44:08', 'Product Configuration Modified: Server Group Modified: \'0\' to \'1\'. WHM Package Name Value Modified: \'Powered\' to \'pro\'. Product ID: 4', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('730', '2022-01-10 03:44:29', 'Product Configuration Modified: Server Group Modified: \'0\' to \'1\'. WHM Package Name Value Modified: \'Powered\' to \'exclusive\'. Product ID: 5', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('731', '2022-01-10 03:47:39', 'General Settings Modified. Changes made: Domain Changed from \'http://client.i3cloud.co.id\' to \'http://client.i3cloud.co.id/\'. Signature Changed. System Emails From Email Changed from \'noreply@client.i3cloud.co.id\' to \'log.i3cloud@gmail.com\'.', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('732', '2022-01-10 03:50:40', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('733', '2022-01-10 03:50:40', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('734', '2022-01-10 03:50:41', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('735', '2022-01-10 03:50:41', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('736', '2022-01-10 03:50:41', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('737', '2022-01-10 03:50:47', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('738', '2022-01-10 03:50:47', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('739', '2022-01-10 03:50:47', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('740', '2022-01-10 03:50:47', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('741', '2022-01-10 03:50:47', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('742', '2022-01-10 03:50:47', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('743', '2022-01-10 03:50:47', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('744', '2022-01-10 03:50:47', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('745', '2022-01-10 03:50:47', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('746', '2022-01-10 03:50:47', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('747', '2022-01-10 03:50:47', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('748', '2022-01-10 03:50:47', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('749', '2022-01-10 03:50:47', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('750', '2022-01-10 03:50:47', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('751', '2022-01-10 03:50:47', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('752', '2022-01-10 03:50:47', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('753', '2022-01-10 03:50:47', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('754', '2022-01-10 03:50:47', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('755', '2022-01-10 03:50:47', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('756', '2022-01-10 03:50:47', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('757', '2022-01-10 03:50:49', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('758', '2022-01-10 03:50:49', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('759', '2022-01-10 03:50:49', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('760', '2022-01-10 03:50:49', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('761', '2022-01-10 03:50:49', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('762', '2022-01-10 03:50:49', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('763', '2022-01-10 03:50:49', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('764', '2022-01-10 03:50:49', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('765', '2022-01-10 03:50:49', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('766', '2022-01-10 03:50:49', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('767', '2022-01-10 03:50:49', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('768', '2022-01-10 03:50:49', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('769', '2022-01-10 03:50:49', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('770', '2022-01-10 03:50:50', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('771', '2022-01-10 03:50:50', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('772', '2022-01-10 03:55:08', 'Domain Pricing Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('773', '2022-01-10 03:56:13', 'Domain Pricing Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('774', '2022-01-10 03:57:04', 'Domain Pricing Modified: \'.id\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('775', '2022-01-10 03:57:51', 'Domain Pricing Modified: \'.com\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('776', '2022-01-10 03:58:31', 'Domain Pricing Modified: \'.net\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('777', '2022-01-10 03:59:28', 'Domain Pricing Modified: \'.sch.id\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('778', '2022-01-10 04:14:21', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('779', '2022-01-10 04:14:29', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('780', '2022-01-10 04:14:32', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('781', '2022-01-10 04:14:53', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('782', '2022-01-10 04:14:58', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('783', '2022-01-10 04:15:50', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('784', '2022-01-10 04:15:53', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('785', '2022-01-10 04:15:54', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('786', '2022-01-10 04:18:00', 'General Settings Modified. Changes made: Domain Changed from \'http://client.i3cloud.co.id/\' to \'http://my.i3cloud.co.id/\'. Logo URL Changed from \'//client.i3cloud.co.id/assets/img/logo.jpg\' to \'//my.i3cloud.co.id/assets/img/logo.jpg\'. System URL Changed from \'http://client.i3cloud.co.id/\' to \'http://my.i3cloud.co.id/\'.', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('787', '2022-01-10 04:18:13', 'General Settings Modified. Changes made: Domain Changed from \'http://my.i3cloud.co.id/\' to \'https://my.i3cloud.co.id/\'. System URL Changed from \'http://my.i3cloud.co.id/\' to \'https://my.i3cloud.co.id/\'.', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('788', '2022-01-10 04:20:18', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('789', '2022-01-10 04:21:32', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('790', '2022-01-10 04:21:32', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('791', '2022-01-10 04:21:33', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('792', '2022-01-10 04:21:33', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('793', '2022-01-10 04:21:33', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('794', '2022-01-10 04:21:38', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('795', '2022-01-10 04:21:38', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('796', '2022-01-10 04:21:38', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('797', '2022-01-10 04:21:38', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('798', '2022-01-10 04:21:38', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('799', '2022-01-10 04:21:38', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('800', '2022-01-10 04:21:38', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('801', '2022-01-10 04:21:38', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('802', '2022-01-10 04:21:38', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('803', '2022-01-10 04:21:38', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('804', '2022-01-10 04:21:38', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('805', '2022-01-10 04:21:38', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('806', '2022-01-10 04:21:38', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('807', '2022-01-10 04:21:38', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('808', '2022-01-10 04:21:38', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('809', '2022-01-10 04:21:38', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('810', '2022-01-10 04:21:38', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('811', '2022-01-10 04:21:38', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('812', '2022-01-10 04:21:38', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('813', '2022-01-10 04:21:38', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('814', '2022-01-10 04:21:39', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('815', '2022-01-10 04:21:39', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('816', '2022-01-10 04:21:39', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('817', '2022-01-10 04:21:39', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('818', '2022-01-10 04:21:39', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('819', '2022-01-10 04:21:39', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('820', '2022-01-10 04:21:39', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('821', '2022-01-10 04:21:40', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('822', '2022-01-10 04:21:40', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('823', '2022-01-10 04:21:40', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('824', '2022-01-10 04:21:40', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('825', '2022-01-10 04:21:40', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('826', '2022-01-10 04:21:40', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('827', '2022-01-10 04:21:40', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('828', '2022-01-10 04:21:40', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('829', '2022-01-10 04:26:56', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('830', '2022-01-10 04:35:40', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('831', '2022-01-10 04:36:13', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('832', '2022-01-10 04:36:54', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('833', '2022-01-10 04:42:09', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('834', '2022-01-10 04:49:02', 'Updated URI Path Mode to: rewrite', 'rofiq', '0', '0', '1', '172.70.142.254');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('835', '2022-01-10 04:49:02', 'Uri Path Management Setting \"URI Mode Override\" Disabled', 'rofiq', '0', '0', '1', '172.70.142.254');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('836', '2022-01-10 04:49:21', 'Updated URI Path Mode to: rewrite', 'rofiq', '0', '0', '1', '172.70.142.254');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('837', '2022-01-10 04:49:21', 'Uri Path Management Setting \"URI Mode Override\" Disabled', 'rofiq', '0', '0', '1', '172.70.142.254');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('838', '2022-01-10 04:52:22', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('839', '2022-01-10 04:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('840', '2022-01-10 04:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('841', '2022-01-10 04:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('842', '2022-01-10 05:05:34', 'Verification Email Resent', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('843', '2022-01-10 05:06:56', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('844', '2022-01-10 05:06:57', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('845', '2022-01-10 05:06:58', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('846', '2022-01-10 05:06:58', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('847', '2022-01-10 05:06:58', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('848', '2022-01-10 05:07:03', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('849', '2022-01-10 05:07:03', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('850', '2022-01-10 05:07:03', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('851', '2022-01-10 05:07:03', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('852', '2022-01-10 05:07:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('853', '2022-01-10 05:07:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('854', '2022-01-10 05:07:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('855', '2022-01-10 05:07:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('856', '2022-01-10 05:07:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('857', '2022-01-10 05:07:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('858', '2022-01-10 05:07:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('859', '2022-01-10 05:07:04', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('860', '2022-01-10 05:07:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('861', '2022-01-10 05:07:04', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('862', '2022-01-10 05:07:04', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('863', '2022-01-10 05:07:04', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('864', '2022-01-10 05:07:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('865', '2022-01-10 05:07:04', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('866', '2022-01-10 05:07:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('867', '2022-01-10 05:07:04', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('868', '2022-01-10 05:07:04', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('869', '2022-01-10 05:07:04', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('870', '2022-01-10 05:07:04', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('871', '2022-01-10 05:07:04', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('872', '2022-01-10 05:07:04', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('873', '2022-01-10 05:07:04', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('874', '2022-01-10 05:07:05', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('875', '2022-01-10 05:07:05', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('876', '2022-01-10 05:07:05', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('877', '2022-01-10 05:07:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('878', '2022-01-10 05:07:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('879', '2022-01-10 05:07:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('880', '2022-01-10 05:07:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('881', '2022-01-10 05:07:05', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('882', '2022-01-10 05:07:06', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('883', '2022-01-10 05:07:40', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('884', '2022-01-10 05:07:40', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('885', '2022-01-10 05:07:41', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('886', '2022-01-10 05:07:41', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('887', '2022-01-10 05:07:41', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('888', '2022-01-10 05:07:44', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('889', '2022-01-10 05:07:44', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('890', '2022-01-10 05:07:44', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('891', '2022-01-10 05:07:44', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('892', '2022-01-10 05:07:44', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('893', '2022-01-10 05:07:44', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('894', '2022-01-10 05:07:44', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('895', '2022-01-10 05:07:44', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('896', '2022-01-10 05:07:44', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('897', '2022-01-10 05:07:44', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('898', '2022-01-10 05:07:44', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('899', '2022-01-10 05:07:44', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('900', '2022-01-10 05:07:44', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('901', '2022-01-10 05:07:44', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('902', '2022-01-10 05:07:44', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('903', '2022-01-10 05:07:44', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('904', '2022-01-10 05:07:44', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('905', '2022-01-10 05:07:44', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('906', '2022-01-10 05:07:44', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('907', '2022-01-10 05:07:44', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('908', '2022-01-10 05:07:45', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('909', '2022-01-10 05:07:45', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('910', '2022-01-10 05:07:45', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('911', '2022-01-10 05:07:45', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('912', '2022-01-10 05:07:45', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('913', '2022-01-10 05:07:46', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('914', '2022-01-10 05:07:46', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('915', '2022-01-10 05:07:46', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('916', '2022-01-10 05:07:46', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('917', '2022-01-10 05:07:46', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('918', '2022-01-10 05:07:46', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('919', '2022-01-10 05:07:46', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('920', '2022-01-10 05:07:46', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('921', '2022-01-10 05:07:46', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('922', '2022-01-10 05:07:47', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('923', '2022-01-10 05:08:34', 'Updated URI Path Mode to: rewrite', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('924', '2022-01-10 05:08:34', 'Uri Path Management Setting \"URI Mode Override\" Disabled', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('925', '2022-01-10 05:08:51', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('926', '2022-01-10 05:08:52', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('927', '2022-01-10 05:08:52', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('928', '2022-01-10 05:08:52', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('929', '2022-01-10 05:08:52', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('930', '2022-01-10 05:08:56', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('931', '2022-01-10 05:08:56', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('932', '2022-01-10 05:08:56', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('933', '2022-01-10 05:08:56', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('934', '2022-01-10 05:08:56', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('935', '2022-01-10 05:08:56', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('936', '2022-01-10 05:08:56', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('937', '2022-01-10 05:08:56', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('938', '2022-01-10 05:08:57', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('939', '2022-01-10 05:08:57', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('940', '2022-01-10 05:08:57', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('941', '2022-01-10 05:08:57', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('942', '2022-01-10 05:08:57', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('943', '2022-01-10 05:08:57', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('944', '2022-01-10 05:08:57', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('945', '2022-01-10 05:08:57', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('946', '2022-01-10 05:08:57', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('947', '2022-01-10 05:08:57', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('948', '2022-01-10 05:08:57', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('949', '2022-01-10 05:08:57', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('950', '2022-01-10 05:08:58', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('951', '2022-01-10 05:08:58', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('952', '2022-01-10 05:08:58', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('953', '2022-01-10 05:08:58', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('954', '2022-01-10 05:08:58', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('955', '2022-01-10 05:08:58', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('956', '2022-01-10 05:08:59', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('957', '2022-01-10 05:08:59', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('958', '2022-01-10 05:08:59', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('959', '2022-01-10 05:08:59', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('960', '2022-01-10 05:08:59', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('961', '2022-01-10 05:08:59', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('962', '2022-01-10 05:08:59', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('963', '2022-01-10 05:08:59', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('964', '2022-01-10 05:09:00', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('965', '2022-01-10 05:10:08', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('966', '2022-01-10 05:10:08', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('967', '2022-01-10 05:10:09', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('968', '2022-01-10 05:10:09', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('969', '2022-01-10 05:10:09', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('970', '2022-01-10 05:10:12', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('971', '2022-01-10 05:10:12', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('972', '2022-01-10 05:10:12', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('973', '2022-01-10 05:10:12', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('974', '2022-01-10 05:10:12', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('975', '2022-01-10 05:10:12', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('976', '2022-01-10 05:10:12', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('977', '2022-01-10 05:10:12', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('978', '2022-01-10 05:10:12', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('979', '2022-01-10 05:10:12', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('980', '2022-01-10 05:10:12', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('981', '2022-01-10 05:10:12', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('982', '2022-01-10 05:10:12', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('983', '2022-01-10 05:10:12', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('984', '2022-01-10 05:10:12', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('985', '2022-01-10 05:10:12', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('986', '2022-01-10 05:10:12', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('987', '2022-01-10 05:10:12', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('988', '2022-01-10 05:10:12', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('989', '2022-01-10 05:10:12', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('990', '2022-01-10 05:10:13', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('991', '2022-01-10 05:10:13', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('992', '2022-01-10 05:10:13', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('993', '2022-01-10 05:10:13', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('994', '2022-01-10 05:10:13', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('995', '2022-01-10 05:10:13', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('996', '2022-01-10 05:10:13', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('997', '2022-01-10 05:10:14', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('998', '2022-01-10 05:10:14', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('999', '2022-01-10 05:10:14', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1000', '2022-01-10 05:10:14', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1001', '2022-01-10 05:10:14', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1002', '2022-01-10 05:10:14', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1003', '2022-01-10 05:10:14', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1004', '2022-01-10 05:10:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1005', '2022-01-10 05:16:06', 'New Order Placed - Order ID: 1 - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1006', '2022-01-10 05:16:06', 'Created Invoice - Invoice ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1007', '2022-01-10 05:16:06', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1008', '2022-01-10 05:16:06', 'Email Sent to Muhammad Rofiq (WHMCS New Order Notification) ', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1009', '2022-01-10 05:16:06', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1010', '2022-01-10 05:16:52', 'Modified Invoice Options - Invoice ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1011', '2022-01-10 05:16:56', 'Email Sent to Muhammad Rofiq (Invoice Payment Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1012', '2022-01-10 05:17:02', 'Modified Invoice - Invoice ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1013', '2022-01-10 05:18:54', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1014', '2022-01-10 05:18:57', 'Module Create Failed - Service ID: 1 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1015', '2022-01-10 05:21:12', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1016', '2022-01-10 05:21:14', 'Module Create Failed - Service ID: 1 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1017', '2022-01-10 05:21:31', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1018', '2022-01-10 05:21:31', 'Module Create Failed - Service ID: 1 - Error: Product attribute Package Name \"newbie\" not found on server', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1019', '2022-01-10 05:21:47', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1020', '2022-01-10 05:21:47', 'Module Create Failed - Service ID: 1 - Error: Product attribute Package Name \"newbie\" not found on server', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1021', '2022-01-10 05:22:27', 'Product Configuration Modified: Server Group Modified: \'1\' to \'0\'. WHM Package Name Value Modified: \'newbie\' to \'Powered\'. Product ID: 2', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1022', '2022-01-10 05:22:38', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1023', '2022-01-10 05:22:40', 'Module Create Successful - Service ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1024', '2022-01-10 05:22:43', 'Email Sent to Muhammad Rofiq (New Account Information)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1025', '2022-01-10 05:22:43', 'Order Accepted - Order ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1026', '2022-01-10 05:26:53', 'Running Module Terminate on Order Cancel', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1027', '2022-01-10 05:26:54', 'Module Terminate Successful - Service ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1028', '2022-01-10 05:26:56', 'Application Link Provisioning returned the following warnings: API failure:   You do not have a user named “nfbfnmuw”. XIDs: g5dr29, e36uuq, abp2af, 78kmpx, 5t2v6n and 10 more.', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1029', '2022-01-10 05:26:56', 'Order Status set to Cancelled - Order ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1030', '2022-01-10 05:27:03', 'Deleted Order - Order ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1031', '2022-01-10 05:28:09', 'Product Configuration Modified: Server Group Modified: \'0\' to \'1\'. WHM Package Name Value Modified: \'Powered\' to \'newbie\'. Product ID: 2', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1032', '2022-01-10 05:29:53', 'New Order Placed - Order ID: 2 - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1033', '2022-01-10 05:29:53', 'Created Invoice - Invoice ID: 2', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1034', '2022-01-10 05:29:54', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1035', '2022-01-10 05:29:54', 'Email Sent to Muhammad Rofiq (WHMCS New Order Notification) ', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1036', '2022-01-10 05:29:54', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1037', '2022-01-10 05:30:25', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1038', '2022-01-10 05:30:28', 'Module Create Failed - Service ID: 2 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1039', '2022-01-10 05:33:12', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1040', '2022-01-10 05:33:15', 'Module Create Failed - Service ID: 2 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1041', '2022-01-10 05:35:08', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1042', '2022-01-10 05:35:09', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1043', '2022-01-10 05:35:09', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1044', '2022-01-10 05:35:10', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1045', '2022-01-10 05:35:10', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1046', '2022-01-10 05:35:14', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1047', '2022-01-10 05:35:14', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1048', '2022-01-10 05:35:14', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1049', '2022-01-10 05:35:14', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1050', '2022-01-10 05:35:14', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1051', '2022-01-10 05:35:14', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1052', '2022-01-10 05:35:14', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1053', '2022-01-10 05:35:14', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1054', '2022-01-10 05:35:14', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1055', '2022-01-10 05:35:14', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1056', '2022-01-10 05:35:14', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1057', '2022-01-10 05:35:14', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1058', '2022-01-10 05:35:14', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1059', '2022-01-10 05:35:14', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1060', '2022-01-10 05:35:14', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1061', '2022-01-10 05:35:14', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1062', '2022-01-10 05:35:14', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1063', '2022-01-10 05:35:14', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1064', '2022-01-10 05:35:14', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1065', '2022-01-10 05:35:14', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1066', '2022-01-10 05:35:15', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1067', '2022-01-10 05:35:15', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1068', '2022-01-10 05:35:15', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1069', '2022-01-10 05:35:15', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1070', '2022-01-10 05:35:15', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1071', '2022-01-10 05:35:15', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1072', '2022-01-10 05:35:16', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1073', '2022-01-10 05:35:16', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1074', '2022-01-10 05:35:16', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1075', '2022-01-10 05:35:16', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1076', '2022-01-10 05:35:16', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1077', '2022-01-10 05:35:16', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1078', '2022-01-10 05:35:16', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1079', '2022-01-10 05:35:16', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1080', '2022-01-10 05:35:16', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1081', '2022-01-10 05:39:24', 'Server Modified: \'Server Indonesia\' - Changes: Access Hash Modified - Server ID: 2', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1082', '2022-01-10 05:39:36', 'Single Sign-on Completed: \'Server Indonesia\' - Server ID: 2', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1083', '2022-01-10 05:39:53', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1084', '2022-01-10 05:39:54', 'Module Create Failed - Service ID: 2 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1085', '2022-01-10 05:56:20', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1086', '2022-01-10 05:56:33', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1087', '2022-01-10 06:09:14', 'General Settings Modified. Changes made: Maintenance Mode Enabled.', 'rofiq', '0', '1', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1088', '2022-01-10 08:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1089', '2022-01-10 08:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1090', '2022-01-10 08:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1091', '2022-01-10 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1092', '2022-01-10 09:00:03', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1093', '2022-01-10 09:00:03', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1094', '2022-01-10 09:00:03', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1095', '2022-01-10 09:00:03', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1096', '2022-01-10 09:00:03', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1097', '2022-01-10 09:00:03', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1098', '2022-01-10 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1099', '2022-01-10 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1100', '2022-01-10 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1101', '2022-01-10 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1102', '2022-01-10 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1103', '2022-01-10 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1104', '2022-01-10 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1105', '2022-01-10 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1106', '2022-01-10 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1107', '2022-01-10 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1108', '2022-01-10 09:00:04', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1109', '2022-01-10 09:00:07', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1110', '2022-01-10 09:00:07', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1111', '2022-01-10 09:00:07', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1112', '2022-01-10 09:00:07', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1113', '2022-01-10 09:00:07', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1114', '2022-01-10 10:54:12', 'Gateway Module Configuration Modified: \'Duitku ShopeePay Applink\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1115', '2022-01-10 10:54:22', 'Gateway Module Configuration Modified: \'Duitku QRIS by ShopeePay\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1116', '2022-01-10 10:54:32', 'Gateway Module Configuration Modified: \'Duitku LinkAja Applink\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1117', '2022-01-10 10:54:47', 'Gateway Module Configuration Modified: \'Duitku LinkAja QRIS\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1118', '2022-01-10 10:54:55', 'Gateway Module Configuration Modified: \'Duitku DANA\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1119', '2022-01-10 10:55:00', 'Gateway Module Configuration Modified: \'Duitku Ovo\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1120', '2022-01-10 10:55:06', 'Gateway Module Configuration Modified: \'Duitku DANA\'', 'rofiq', '0', '0', '1', '182.1.70.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1121', '2022-01-10 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1122', '2022-01-10 12:55:11', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1123', '2022-01-10 12:55:11', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1124', '2022-01-10 12:55:11', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1125', '2022-01-10 16:59:35', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1126', '2022-01-10 16:59:35', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1127', '2022-01-10 16:59:35', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1128', '2022-01-10 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1129', '2022-01-10 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1130', '2022-01-10 20:58:35', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1131', '2022-01-10 20:58:35', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1132', '2022-01-10 20:58:35', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1133', '2022-01-11 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1134', '2022-01-11 00:56:59', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1135', '2022-01-11 00:56:59', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1136', '2022-01-11 00:56:59', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1137', '2022-01-11 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1138', '2022-01-11 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1139', '2022-01-11 04:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1140', '2022-01-11 04:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1141', '2022-01-11 04:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1142', '2022-01-11 08:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1143', '2022-01-11 08:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1144', '2022-01-11 08:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1145', '2022-01-11 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1146', '2022-01-11 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1147', '2022-01-11 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1148', '2022-01-11 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1149', '2022-01-11 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1150', '2022-01-11 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1151', '2022-01-11 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1152', '2022-01-11 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1153', '2022-01-11 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1154', '2022-01-11 09:00:06', 'Email Sent to Muhammad Rofiq (First Invoice Overdue Notice)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1155', '2022-01-11 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1156', '2022-01-11 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1157', '2022-01-11 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1158', '2022-01-11 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1159', '2022-01-11 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1160', '2022-01-11 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1161', '2022-01-11 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1162', '2022-01-11 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1163', '2022-01-11 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1164', '2022-01-11 09:00:07', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1165', '2022-01-11 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1166', '2022-01-11 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1167', '2022-01-11 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1168', '2022-01-11 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1169', '2022-01-11 09:00:12', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1170', '2022-01-11 09:00:12', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1171', '2022-01-11 09:00:12', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1172', '2022-01-11 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1173', '2022-01-11 12:55:11', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1174', '2022-01-11 12:55:11', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1175', '2022-01-11 12:55:11', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1176', '2022-01-11 16:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1177', '2022-01-11 16:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1178', '2022-01-11 16:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1179', '2022-01-11 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1180', '2022-01-11 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1181', '2022-01-11 20:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1182', '2022-01-11 20:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1183', '2022-01-11 20:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1184', '2022-01-12 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1185', '2022-01-12 00:55:13', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1186', '2022-01-12 00:55:13', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1187', '2022-01-12 00:55:13', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1188', '2022-01-12 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1189', '2022-01-12 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1190', '2022-01-12 04:51:44', 'Server Modified: \'Server Indonesia\' - Changes: Access Hash Modified. Password Modified - Server ID: 2', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1191', '2022-01-12 04:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1192', '2022-01-12 04:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1193', '2022-01-12 04:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1194', '2022-01-12 05:06:14', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1195', '2022-01-12 05:06:17', 'Module Create Failed - Service ID: 2 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1196', '2022-01-12 05:06:42', 'Server Modified: \'Server Indonesia\' - Changes: Maximum No. of Accounts Modified: \'200\' to \'50\' - Server ID: 2', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1197', '2022-01-12 05:06:56', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1198', '2022-01-12 05:06:58', 'Module Create Failed - Service ID: 2 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1199', '2022-01-12 05:34:17', 'Server Modified: \'Server Indonesia\' - Changes: Maximum No. of Accounts Modified: \'50\' to \'200\' - Server ID: 2', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1200', '2022-01-12 06:34:51', 'General Settings Modified. Changes made: Maintenance Mode Disabled.', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1201', '2022-01-12 06:36:30', 'Modified Announcement (ID: 1)', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1202', '2022-01-12 06:37:32', 'General Settings Modified. Changes made: Captcha Forms Changed from \'{\"checkoutCompletion\":false,\"domainChecker\":true,\"registration\":true,\"contactUs\":true,\"submitTicket\":true,\"login\":false}\' to \'{\"checkoutCompletion\":false,\"domainChecker\":false,\"registration\":true,\"contactUs\":true,\"submitTicket\":true,\"login\":false}\'.', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1203', '2022-01-12 07:09:43', 'General Settings Modified. Changes made: Maintenance Mode Enabled.', 'rofiq', '0', '0', '1', '182.1.78.170');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1204', '2022-01-12 08:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1205', '2022-01-12 08:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1206', '2022-01-12 08:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1207', '2022-01-12 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1208', '2022-01-12 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1209', '2022-01-12 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1210', '2022-01-12 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1211', '2022-01-12 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1212', '2022-01-12 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1213', '2022-01-12 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1214', '2022-01-12 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1215', '2022-01-12 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1216', '2022-01-12 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1217', '2022-01-12 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1218', '2022-01-12 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1219', '2022-01-12 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1220', '2022-01-12 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1221', '2022-01-12 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1222', '2022-01-12 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1223', '2022-01-12 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1224', '2022-01-12 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1225', '2022-01-12 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1226', '2022-01-12 09:00:07', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1227', '2022-01-12 09:00:07', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1228', '2022-01-12 09:00:07', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1229', '2022-01-12 09:00:07', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1230', '2022-01-12 09:00:07', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1231', '2022-01-12 09:00:07', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1232', '2022-01-12 09:00:07', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1233', '2022-01-12 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1234', '2022-01-12 12:55:13', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1235', '2022-01-12 12:55:13', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1236', '2022-01-12 12:55:13', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1237', '2022-01-12 16:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1238', '2022-01-12 16:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1239', '2022-01-12 16:55:04', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1240', '2022-01-12 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1241', '2022-01-12 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1242', '2022-01-12 20:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1243', '2022-01-12 20:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1244', '2022-01-12 20:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1245', '2022-01-13 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1246', '2022-01-13 00:55:10', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1247', '2022-01-13 00:55:10', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1248', '2022-01-13 00:55:11', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1249', '2022-01-13 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1250', '2022-01-13 01:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1251', '2022-01-13 04:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1252', '2022-01-13 04:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1253', '2022-01-13 04:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1254', '2022-01-13 08:29:36', 'General Settings Modified. Changes made: Maintenance Mode Disabled.', 'rofiq', '0', '0', '1', '103.144.169.83');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1255', '2022-01-13 08:51:45', 'New Order Placed - Order ID: 3 - User ID: 1', 'rofiq', '1', '1', '1', '103.144.169.83');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1256', '2022-01-13 08:51:45', 'Created Invoice - Invoice ID: 3', 'rofiq', '1', '1', '1', '103.144.169.83');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1257', '2022-01-13 08:51:45', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'rofiq', '1', '1', '1', '103.144.169.83');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1258', '2022-01-13 08:51:46', 'Email Sent to Muhammad Rofiq (WHMCS New Order Notification) ', 'rofiq', '0', '1', '1', '103.144.169.83');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1259', '2022-01-13 08:51:46', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '103.144.169.83');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1260', '2022-01-13 08:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1261', '2022-01-13 08:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1262', '2022-01-13 08:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1263', '2022-01-13 08:57:02', 'Added Transaction - Transaction ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1264', '2022-01-13 08:57:02', 'Added Invoice Payment - Invoice ID: 3', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1265', '2022-01-13 08:57:02', 'Invoice Marked Paid - Invoice ID: 3', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1266', '2022-01-13 08:57:03', 'Email Sent to Muhammad Rofiq (Invoice Payment Confirmation)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1267', '2022-01-13 08:57:03', 'Running Automatic Domain Registration on Payment', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1268', '2022-01-13 08:57:03', 'Domain Registration Failed - Domain ID: 1 - Domain: i3webcloud.my.id - Error: Customer create error Address 1 cannot be less than 3 characters', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1269', '2022-01-13 08:59:03', 'Domain Registration Failed - Domain ID: 1 - Domain: i3webcloud.my.id - Error: Customer create error Address 1 cannot be less than 3 characters', 'rofiq', '1', '1', '1', '114.125.92.253');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1270', '2022-01-13 08:59:54', 'Client Profile Modified - Address 1: \'JL\' to \'JL penataran 01\' - User ID: 1', 'rofiq', '1', '1', '1', '114.125.92.253');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1271', '2022-01-13 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1272', '2022-01-13 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1273', '2022-01-13 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1274', '2022-01-13 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1275', '2022-01-13 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1276', '2022-01-13 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1277', '2022-01-13 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1278', '2022-01-13 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1279', '2022-01-13 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1280', '2022-01-13 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1281', '2022-01-13 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1282', '2022-01-13 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1283', '2022-01-13 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1284', '2022-01-13 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1285', '2022-01-13 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1286', '2022-01-13 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1287', '2022-01-13 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1288', '2022-01-13 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1289', '2022-01-13 09:00:07', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1290', '2022-01-13 09:00:08', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1291', '2022-01-13 09:00:08', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1292', '2022-01-13 09:00:08', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1293', '2022-01-13 09:00:08', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1294', '2022-01-13 09:00:08', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1295', '2022-01-13 09:00:08', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1296', '2022-01-13 09:00:08', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1297', '2022-01-13 09:02:44', 'Domain Registered Successfully - Domain ID: 1 - Domain: i3webcloud.my.id', 'rofiq', '1', '1', '1', '114.125.92.253');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1298', '2022-01-13 09:02:44', 'Email Sent to Muhammad Rofiq (Domain Registration Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '114.125.92.253');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1299', '2022-01-13 09:02:44', 'Order Accepted - Order ID: 3', 'rofiq', '1', '1', '1', '114.125.92.253');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1300', '2022-01-13 11:00:57', 'Domain Pricing Options Modified: \'.co.id\'', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1301', '2022-01-13 11:00:57', 'Domain Pricing Options Modified: \'.my.id\'', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1302', '2022-01-13 11:00:57', 'Domain Pricing Options Modified: \'.id\'', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1303', '2022-01-13 11:00:57', 'Domain Pricing Options Modified: \'.com\'', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1304', '2022-01-13 11:05:43', 'Admin User \'admin\' with role Full Administrator created', 'rofiq', '0', '0', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1305', '2022-01-13 11:15:10', 'Server Group Created: \'Server A\' - Server Group ID: 2', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1306', '2022-01-13 11:15:26', 'Server Group Modified: \'Server B\' - Changes: Name Modified: \'ns2.i3cloud.co.id\' to \'Server B\' - Server Group ID: 1', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1307', '2022-01-13 11:17:07', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 2', 'rofiq', '0', '0', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1308', '2022-01-13 11:17:32', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 3', 'rofiq', '0', '0', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1309', '2022-01-13 11:17:47', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 4', 'rofiq', '0', '0', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1310', '2022-01-13 11:18:00', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 5', 'rofiq', '0', '0', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1311', '2022-01-13 11:20:58', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '162.158.166.87');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1312', '2022-01-13 11:21:01', 'Module Create Successful - Service ID: 2', 'rofiq', '1', '0', '1', '162.158.166.87');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1313', '2022-01-13 11:21:04', 'Email Sent to Muhammad Rofiq (New Account Information)  - User ID: 1', 'rofiq', '1', '0', '1', '162.158.166.87');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1314', '2022-01-13 11:21:04', 'Order Accepted - Order ID: 2', 'rofiq', '1', '0', '1', '162.158.166.87');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1315', '2022-01-13 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1316', '2022-01-13 12:55:11', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1317', '2022-01-13 12:55:11', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1318', '2022-01-13 12:55:12', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1319', '2022-01-13 13:36:08', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1320', '2022-01-13 16:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1321', '2022-01-13 16:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1322', '2022-01-13 16:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1323', '2022-01-13 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1324', '2022-01-13 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1325', '2022-01-13 20:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1326', '2022-01-13 20:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1327', '2022-01-13 20:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1328', '2022-01-14 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1329', '2022-01-14 00:55:10', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1330', '2022-01-14 00:55:10', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1331', '2022-01-14 00:55:11', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1332', '2022-01-14 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1333', '2022-01-14 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1334', '2022-01-14 04:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1335', '2022-01-14 04:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1336', '2022-01-14 04:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1337', '2022-01-14 08:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1338', '2022-01-14 08:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1339', '2022-01-14 08:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1340', '2022-01-14 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1341', '2022-01-14 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1342', '2022-01-14 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1343', '2022-01-14 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1344', '2022-01-14 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1345', '2022-01-14 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1346', '2022-01-14 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1347', '2022-01-14 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1348', '2022-01-14 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1349', '2022-01-14 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1350', '2022-01-14 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1351', '2022-01-14 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1352', '2022-01-14 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1353', '2022-01-14 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1354', '2022-01-14 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1355', '2022-01-14 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1356', '2022-01-14 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1357', '2022-01-14 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1358', '2022-01-14 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1359', '2022-01-14 09:00:07', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1360', '2022-01-14 09:00:07', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1361', '2022-01-14 09:00:07', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1362', '2022-01-14 09:00:07', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1363', '2022-01-14 09:00:07', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1364', '2022-01-14 09:00:07', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1365', '2022-01-14 09:00:08', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1366', '2022-01-14 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1367', '2022-01-14 12:55:12', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1368', '2022-01-14 12:55:12', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1369', '2022-01-14 12:55:13', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1370', '2022-01-14 16:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1371', '2022-01-14 16:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1372', '2022-01-14 16:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1373', '2022-01-14 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1374', '2022-01-14 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1375', '2022-01-14 20:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1376', '2022-01-14 20:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1377', '2022-01-14 20:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1378', '2022-01-15 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1379', '2022-01-15 00:59:00', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1380', '2022-01-15 00:59:00', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1381', '2022-01-15 00:59:00', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1382', '2022-01-15 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1383', '2022-01-15 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1384', '2022-01-15 04:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1385', '2022-01-15 04:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1386', '2022-01-15 04:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1387', '2022-01-15 08:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1388', '2022-01-15 08:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1389', '2022-01-15 08:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1390', '2022-01-15 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1391', '2022-01-15 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1392', '2022-01-15 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1393', '2022-01-15 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1394', '2022-01-15 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1395', '2022-01-15 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1396', '2022-01-15 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1397', '2022-01-15 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1398', '2022-01-15 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1399', '2022-01-15 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1400', '2022-01-15 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1401', '2022-01-15 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1402', '2022-01-15 09:00:05', 'Cron Job: Suspending Service - Service ID: 2', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1403', '2022-01-15 09:00:07', 'Module Suspend Successful - Service ID: 2', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1404', '2022-01-15 09:00:10', 'Email Sent to Muhammad Rofiq (Service Suspension Notification)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1405', '2022-01-15 09:00:10', 'Cron Job: SUCCESS: NEWBIE - i3webhost.my.id - Muhammad Rofiq (Service ID: 2 - User ID: 1)', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1406', '2022-01-15 09:00:10', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1407', '2022-01-15 09:00:10', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1408', '2022-01-15 09:00:10', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1409', '2022-01-15 09:00:10', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1410', '2022-01-15 09:00:10', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1411', '2022-01-15 09:00:10', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1412', '2022-01-15 09:00:10', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1413', '2022-01-15 09:00:15', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1414', '2022-01-15 09:00:15', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1415', '2022-01-15 09:00:15', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1416', '2022-01-15 09:00:16', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1417', '2022-01-15 09:00:16', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1418', '2022-01-15 09:00:16', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1419', '2022-01-15 09:00:16', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1420', '2022-01-15 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1421', '2022-01-15 12:55:19', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1422', '2022-01-15 12:55:19', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1423', '2022-01-15 12:55:20', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1424', '2022-01-15 16:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1425', '2022-01-15 16:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1426', '2022-01-15 16:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1427', '2022-01-15 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1428', '2022-01-15 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1429', '2022-01-15 20:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1430', '2022-01-15 20:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1431', '2022-01-15 20:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1432', '2022-01-16 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1433', '2022-01-16 00:55:22', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1434', '2022-01-16 00:55:22', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1435', '2022-01-16 00:55:23', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1436', '2022-01-16 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1437', '2022-01-16 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1438', '2022-01-16 04:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1439', '2022-01-16 04:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1440', '2022-01-16 04:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1441', '2022-01-16 08:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1442', '2022-01-16 08:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1443', '2022-01-16 08:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1444', '2022-01-16 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1445', '2022-01-16 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1446', '2022-01-16 09:00:06', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1447', '2022-01-16 09:00:06', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1448', '2022-01-16 09:00:06', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1449', '2022-01-16 09:00:06', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1450', '2022-01-16 09:00:06', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1451', '2022-01-16 09:00:06', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1452', '2022-01-16 09:00:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1453', '2022-01-16 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1454', '2022-01-16 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1455', '2022-01-16 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1456', '2022-01-16 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1457', '2022-01-16 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1458', '2022-01-16 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1459', '2022-01-16 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1460', '2022-01-16 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1461', '2022-01-16 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1462', '2022-01-16 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1463', '2022-01-16 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1464', '2022-01-16 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1465', '2022-01-16 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1466', '2022-01-16 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1467', '2022-01-16 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1468', '2022-01-16 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1469', '2022-01-16 09:00:12', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1470', '2022-01-16 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1471', '2022-01-16 12:55:22', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1472', '2022-01-16 12:55:22', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1473', '2022-01-16 12:55:23', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1474', '2022-01-16 13:18:00', 'Failed Admin Login Attempt - Username: admin', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1475', '2022-01-16 16:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1476', '2022-01-16 16:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1477', '2022-01-16 16:55:10', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1478', '2022-01-16 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1479', '2022-01-16 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1480', '2022-01-16 20:55:09', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1481', '2022-01-16 20:55:09', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1482', '2022-01-16 20:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1483', '2022-01-17 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1484', '2022-01-17 00:55:20', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1485', '2022-01-17 00:55:20', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1486', '2022-01-17 00:55:20', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1487', '2022-01-17 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1488', '2022-01-17 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1489', '2022-01-17 04:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1490', '2022-01-17 04:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1491', '2022-01-17 04:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1492', '2022-01-17 08:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1493', '2022-01-17 08:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1494', '2022-01-17 08:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1495', '2022-01-17 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1496', '2022-01-17 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1497', '2022-01-17 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1498', '2022-01-17 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1499', '2022-01-17 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1500', '2022-01-17 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1501', '2022-01-17 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1502', '2022-01-17 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1503', '2022-01-17 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1504', '2022-01-17 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1505', '2022-01-17 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1506', '2022-01-17 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1507', '2022-01-17 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1508', '2022-01-17 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1509', '2022-01-17 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1510', '2022-01-17 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1511', '2022-01-17 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1512', '2022-01-17 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1513', '2022-01-17 09:00:18', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1514', '2022-01-17 09:00:23', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1515', '2022-01-17 09:00:23', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1516', '2022-01-17 09:00:24', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1517', '2022-01-17 09:00:24', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1518', '2022-01-17 09:00:24', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1519', '2022-01-17 09:00:24', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1520', '2022-01-17 09:00:24', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1521', '2022-01-17 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1522', '2022-01-17 12:55:20', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1523', '2022-01-17 12:55:20', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1524', '2022-01-17 12:55:21', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1525', '2022-01-17 16:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1526', '2022-01-17 16:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1527', '2022-01-17 16:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1528', '2022-01-17 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1529', '2022-01-17 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1530', '2022-01-17 20:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1531', '2022-01-17 20:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1532', '2022-01-17 20:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1533', '2022-01-18 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1534', '2022-01-18 00:55:18', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1535', '2022-01-18 00:55:18', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1536', '2022-01-18 00:55:19', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1537', '2022-01-18 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1538', '2022-01-18 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1539', '2022-01-18 04:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1540', '2022-01-18 04:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1541', '2022-01-18 04:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1542', '2022-01-18 07:07:48', 'Running Module Terminate on Order Cancel', 'rofiq', '1', '0', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1543', '2022-01-18 07:07:52', 'Module Terminate Successful - Service ID: 2', 'rofiq', '1', '0', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1544', '2022-01-18 07:07:55', 'Application Link Provisioning returned the following warnings: API failure:   You do not have a user named “idjchwqa”. XIDs: s2negw, amkpxe, peyrun, j75k8z, h2fd33 and 10 more.', 'rofiq', '0', '0', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1545', '2022-01-18 07:07:55', 'Order Status set to Cancelled - Order ID: 2', 'rofiq', '1', '0', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1546', '2022-01-18 07:17:18', 'Deleted Order - Order ID: 2', 'rofiq', '1', '0', '1', '162.158.165.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1547', '2022-01-18 07:18:47', 'Product Configuration Modified: Product Description Modified. Product ID: 2', 'rofiq', '0', '0', '1', '162.158.165.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1548', '2022-01-18 07:19:09', 'Product Configuration Modified: Product Description Modified. Product ID: 3', 'rofiq', '0', '0', '1', '162.158.165.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1549', '2022-01-18 07:19:32', 'Product Configuration Modified: Product Description Modified. Product ID: 4', 'rofiq', '0', '0', '1', '162.158.165.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1550', '2022-01-18 07:20:04', 'Product Configuration Modified: Product Description Modified. Product ID: 5', 'rofiq', '0', '0', '1', '162.158.165.20');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1551', '2022-01-18 08:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1552', '2022-01-18 08:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1553', '2022-01-18 08:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1554', '2022-01-18 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1555', '2022-01-18 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1556', '2022-01-18 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1557', '2022-01-18 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1558', '2022-01-18 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1559', '2022-01-18 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1560', '2022-01-18 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1561', '2022-01-18 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1562', '2022-01-18 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1563', '2022-01-18 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1564', '2022-01-18 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1565', '2022-01-18 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1566', '2022-01-18 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1567', '2022-01-18 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1568', '2022-01-18 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1569', '2022-01-18 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1570', '2022-01-18 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1571', '2022-01-18 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1572', '2022-01-18 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1573', '2022-01-18 09:00:10', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1574', '2022-01-18 09:00:10', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1575', '2022-01-18 09:00:10', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1576', '2022-01-18 09:00:10', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1577', '2022-01-18 09:00:10', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1578', '2022-01-18 09:00:10', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1579', '2022-01-18 09:00:10', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1580', '2022-01-18 10:28:35', 'Failed Admin Login Attempt - Username: rofiq', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1581', '2022-01-18 10:50:24', 'Server Modified: \'Server Indonesia\' - Changes: Primary Nameserver Modified: \'ns2.i3cloud.co.id\' to \'asia-sg.serverdns.cloud\'. Secondary Nameserver Modified: \'\' to \'asia-jkt.serverdns.cloud\'. Third Nameserver Modified: \'\' to \'asia-bogor.serverdns.cloud\' - Server ID: 2', 'rofiq', '0', '0', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1582', '2022-01-18 10:50:44', 'Server Modified: \'Server Singapure\' - Changes: Secondary Nameserver Modified: \'\' to \'ns2.i3cloud.co.id\' - Server ID: 1', 'rofiq', '0', '0', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1583', '2022-01-18 11:08:55', 'Email Sent to Muhammad Rofiq (Domain Registration Confirmation)  - User ID: 1', 'rofiq', '1', '0', '1', '162.158.165.166');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1584', '2022-01-18 12:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1585', '2022-01-18 12:55:21', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1586', '2022-01-18 12:55:21', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1587', '2022-01-18 12:55:22', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1588', '2022-01-18 16:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1589', '2022-01-18 16:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1590', '2022-01-18 16:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1591', '2022-01-18 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1592', '2022-01-18 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1593', '2022-01-18 20:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1594', '2022-01-18 20:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1595', '2022-01-18 20:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1596', '2022-01-19 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1597', '2022-01-19 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1598', '2022-01-19 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1599', '2022-01-19 01:07:43', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1600', '2022-01-19 01:07:43', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1601', '2022-01-19 01:07:44', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1602', '2022-01-19 04:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1603', '2022-01-19 04:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1604', '2022-01-19 04:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1605', '2022-01-19 08:57:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1606', '2022-01-19 08:57:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1607', '2022-01-19 08:57:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1608', '2022-01-19 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1609', '2022-01-19 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1610', '2022-01-19 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1611', '2022-01-19 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1612', '2022-01-19 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1613', '2022-01-19 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1614', '2022-01-19 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1615', '2022-01-19 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1616', '2022-01-19 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1617', '2022-01-19 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1618', '2022-01-19 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1619', '2022-01-19 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1620', '2022-01-19 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1621', '2022-01-19 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1622', '2022-01-19 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1623', '2022-01-19 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1624', '2022-01-19 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1625', '2022-01-19 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1626', '2022-01-19 09:00:16', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1627', '2022-01-19 09:00:46', 'Server Usage Update Failed: Connection Error: Operation timed out after 30000 milliseconds with 0 bytes received(28) - Server ID: 2', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1628', '2022-01-19 09:00:46', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1629', '2022-01-19 09:00:46', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1630', '2022-01-19 09:00:46', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1631', '2022-01-19 09:00:46', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1632', '2022-01-19 09:00:46', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1633', '2022-01-19 09:00:46', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1634', '2022-01-19 09:00:47', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1635', '2022-01-19 09:38:38', 'Verification Email Resent', 'mrofiq990@gmail.com', '1', '1', '0', '162.158.165.6');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1636', '2022-01-19 09:58:53', 'New Order Placed - Order ID: 4 - User ID: 1', 'mrofiq990@gmail.com', '1', '1', '0', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1637', '2022-01-19 09:58:53', 'Created Invoice - Invoice ID: 4', 'mrofiq990@gmail.com', '1', '1', '0', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1638', '2022-01-19 09:58:53', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'mrofiq990@gmail.com', '1', '1', '0', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1639', '2022-01-19 09:58:53', 'Email Sent to Muhammad Rofiq (WHMCS New Order Notification) ', 'mrofiq990@gmail.com', '1', '1', '0', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1640', '2022-01-19 09:58:53', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'mrofiq990@gmail.com', '1', '1', '0', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1641', '2022-01-19 10:10:14', 'Added Transaction - Transaction ID: 2', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1642', '2022-01-19 10:10:14', 'Added Invoice Payment - Invoice ID: 4', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1643', '2022-01-19 10:10:14', 'Invoice Marked Paid - Invoice ID: 4', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1644', '2022-01-19 10:10:14', 'Email Sent to Muhammad Rofiq (Invoice Payment Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1645', '2022-01-19 10:10:14', 'Running Module Create on Payment', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1646', '2022-01-19 10:10:17', 'Module Create Successful - Service ID: 3', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1647', '2022-01-19 10:10:20', 'Email Sent to Muhammad Rofiq (New Account Information)  - User ID: 1', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1648', '2022-01-19 10:10:20', 'Running Automatic Domain Registration on Payment', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1649', '2022-01-19 10:10:43', 'Domain Registered Successfully - Domain ID: 2 - Domain: i3webhost.co.id', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1650', '2022-01-19 10:10:43', 'Email Sent to Muhammad Rofiq (Domain Registration Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '172.70.147.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1651', '2022-01-19 10:11:43', 'Order Accepted - Order ID: 4', 'rofiq', '1', '1', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1652', '2022-01-19 10:13:06', 'Gateway Module Configuration Modified: \'Duitku LinkAja QRIS\'', 'rofiq', '0', '1', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1653', '2022-01-19 10:13:13', 'Gateway Module Configuration Modified: \'Duitku QRIS by ShopeePay\'', 'rofiq', '0', '1', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1654', '2022-01-19 10:13:42', 'Gateway Module Configuration Modified: \'Duitku ShopeePay Applink\'', 'rofiq', '0', '1', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1655', '2022-01-19 10:13:48', 'Gateway Module Configuration Modified: \'Duitku LinkAja Applink\'', 'rofiq', '0', '1', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1656', '2022-01-19 10:40:55', 'Addon Module Activated - Liquid Upload Documents', 'rofiq', '0', '1', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1657', '2022-01-19 10:42:07', 'Addon Module Activated - Liquid Upload Documents', 'rofiq', '0', '1', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1658', '2022-01-19 10:47:34', 'Addon Module Access Permissions Changed - Liquid Upload Documents -  Added Role Group(s): Full Administrator.', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1659', '2022-01-19 10:47:34', 'Addon Module Settings Modified - Liquid Upload Documents  - Initial setting of ResellerID to \'11511\', Initial setting of Apikey to \'72d9a3e3081483958336e0f3524b8c71\', Initial setting of Recaptcha Public Key to \'6LcwPyIeAAAAALImxP-9-wsa9uWS-79tBqAJKTH4\', Initial setting of Recaptcha Secret Key to \'6LcwPyIeAAAAADOGl8xKT7Nfa9nfyOy7PUMW772Y\', Initial setting of TestMode to \'\'', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1660', '2022-01-19 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1661', '2022-01-19 12:58:39', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1662', '2022-01-19 12:58:39', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1663', '2022-01-19 12:58:39', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1664', '2022-01-19 16:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1665', '2022-01-19 16:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1666', '2022-01-19 16:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1667', '2022-01-19 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1668', '2022-01-19 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1669', '2022-01-19 20:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1670', '2022-01-19 20:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1671', '2022-01-19 20:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1672', '2022-01-20 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1673', '2022-01-20 00:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1674', '2022-01-20 00:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1675', '2022-01-20 00:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1676', '2022-01-20 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1677', '2022-01-20 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1678', '2022-01-20 02:26:19', 'Failed Admin Login Attempt - Username: admin', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1679', '2022-01-20 02:26:30', 'Failed Admin Login Attempt - Username: admin', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1680', '2022-01-20 04:59:26', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1681', '2022-01-20 04:59:26', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1682', '2022-01-20 04:59:29', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1683', '2022-01-20 05:45:07', 'Failed Admin Login Attempt - Username: admin', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1684', '2022-01-20 05:50:10', 'General Settings Modified. Changes made: Domain Changed from \'http://my.i3cloud.co.id\' to \'http://my.i3cloud.co.id/\'. Signature Changed. Captcha Type Changed from \'\' to \'invisible\'.', 'admin', '0', '0', '3', '172.70.147.100');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1685', '2022-01-20 05:54:51', 'General Settings Modified. Changes made: Signature Changed.', 'admin', '0', '0', '3', '172.70.147.100');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1686', '2022-01-20 06:07:15', 'SMTP Debug: Connection: opening to ssl://smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.46');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1687', '2022-01-20 06:07:15', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.46');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1688', '2022-01-20 06:07:15', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.46');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1689', '2022-01-20 06:07:15', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://smtp.gmail.com:587 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.46');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1690', '2022-01-20 06:07:15', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'rofiq', '0', '0', '1', '162.158.162.46');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1691', '2022-01-20 06:07:15', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'rofiq', '0', '0', '1', '162.158.162.46');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1692', '2022-01-20 06:17:43', 'SMTP Debug: Connection: opening to smtp.gmail.com:25, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1693', '2022-01-20 06:17:43', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1694', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:17:43 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1695', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1696', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1697', '2022-01-20 06:17:43', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:17:43 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1698', '2022-01-20 06:17:43', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1699', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1700', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1701', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1702', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1703', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1704', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1705', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1706', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1707', '2022-01-20 06:17:43', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1708', '2022-01-20 06:17:43', 'SMTP Debug: Auth method requested: UNSPECIFIED', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1709', '2022-01-20 06:17:43', 'SMTP Debug: Auth methods available on the server: PLAIN,LOGIN', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1710', '2022-01-20 06:17:43', 'SMTP Debug: Requested auth method not available: ', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1711', '2022-01-20 06:17:43', 'SMTP Debug: Auth method selected: LOGIN', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1712', '2022-01-20 06:17:43', 'SMTP Debug: CLIENT -> SERVER: AUTH LOGIN\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1713', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"334 VXNlcm5hbWU6\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1714', '2022-01-20 06:17:43', 'SMTP Debug: SERVER -> CLIENT: 334 VXNlcm5hbWU6\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1715', '2022-01-20 06:17:43', 'SMTP Debug: CLIENT -> SERVER: bXJvZmlxNDY2QGdtYWlsLmNvbQ==\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1716', '2022-01-20 06:17:43', 'SMTP Debug: SMTP INBOUND: \"334 UGFzc3dvcmQ6\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1717', '2022-01-20 06:17:43', 'SMTP Debug: SERVER -> CLIENT: 334 UGFzc3dvcmQ6\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1718', '2022-01-20 06:17:43', 'SMTP Debug: CLIENT -> SERVER: I1JhaGFzaWExMjMhQA==\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1719', '2022-01-20 06:17:45', 'SMTP Debug: SMTP INBOUND: \"535 Incorrect authentication data\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1720', '2022-01-20 06:17:45', 'SMTP Debug: SERVER -> CLIENT: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1721', '2022-01-20 06:17:45', 'SMTP Debug: SMTP ERROR: Password command failed: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1722', '2022-01-20 06:17:45', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1723', '2022-01-20 06:17:45', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1724', '2022-01-20 06:17:45', 'SMTP Debug: SMTP INBOUND: \"221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1725', '2022-01-20 06:17:45', 'SMTP Debug: SERVER -> CLIENT: 221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1726', '2022-01-20 06:17:45', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1727', '2022-01-20 06:17:45', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1728', '2022-01-20 06:18:03', 'SMTP Debug: Connection: opening to smtp.gmail.com:25, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1729', '2022-01-20 06:18:03', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1730', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:18:03 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1731', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1732', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1733', '2022-01-20 06:18:03', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:18:03 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1734', '2022-01-20 06:18:03', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1735', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1736', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1737', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1738', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1739', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1740', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1741', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1742', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1743', '2022-01-20 06:18:03', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1744', '2022-01-20 06:18:03', 'SMTP Debug: Auth method requested: UNSPECIFIED', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1745', '2022-01-20 06:18:03', 'SMTP Debug: Auth methods available on the server: PLAIN,LOGIN', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1746', '2022-01-20 06:18:03', 'SMTP Debug: Requested auth method not available: ', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1747', '2022-01-20 06:18:03', 'SMTP Debug: Auth method selected: LOGIN', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1748', '2022-01-20 06:18:03', 'SMTP Debug: CLIENT -> SERVER: AUTH LOGIN\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1749', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"334 VXNlcm5hbWU6\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1750', '2022-01-20 06:18:03', 'SMTP Debug: SERVER -> CLIENT: 334 VXNlcm5hbWU6\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1751', '2022-01-20 06:18:03', 'SMTP Debug: CLIENT -> SERVER: bXJvZmlxNDY2QGdtYWlsLmNvbQ==\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1752', '2022-01-20 06:18:03', 'SMTP Debug: SMTP INBOUND: \"334 UGFzc3dvcmQ6\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1753', '2022-01-20 06:18:03', 'SMTP Debug: SERVER -> CLIENT: 334 UGFzc3dvcmQ6\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1754', '2022-01-20 06:18:03', 'SMTP Debug: CLIENT -> SERVER: I01yQDIxMzM0NjU1\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1755', '2022-01-20 06:18:05', 'SMTP Debug: SMTP INBOUND: \"535 Incorrect authentication data\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1756', '2022-01-20 06:18:05', 'SMTP Debug: SERVER -> CLIENT: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1757', '2022-01-20 06:18:05', 'SMTP Debug: SMTP ERROR: Password command failed: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1758', '2022-01-20 06:18:05', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1759', '2022-01-20 06:18:05', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1760', '2022-01-20 06:18:05', 'SMTP Debug: SMTP INBOUND: \"221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1761', '2022-01-20 06:18:05', 'SMTP Debug: SERVER -> CLIENT: 221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1762', '2022-01-20 06:18:05', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1763', '2022-01-20 06:18:05', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1764', '2022-01-20 06:18:20', 'SMTP Debug: Connection: opening to smtp.gmail.com:25, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1765', '2022-01-20 06:18:20', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1766', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:18:20 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1767', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1768', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1769', '2022-01-20 06:18:20', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:18:20 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1770', '2022-01-20 06:18:20', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1771', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1772', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1773', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1774', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1775', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1776', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1777', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1778', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1779', '2022-01-20 06:18:20', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1780', '2022-01-20 06:18:20', 'SMTP Debug: Auth method requested: UNSPECIFIED', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1781', '2022-01-20 06:18:20', 'SMTP Debug: Auth methods available on the server: PLAIN,LOGIN', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1782', '2022-01-20 06:18:20', 'SMTP Debug: Requested auth method not available: ', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1783', '2022-01-20 06:18:20', 'SMTP Debug: Auth method selected: LOGIN', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1784', '2022-01-20 06:18:20', 'SMTP Debug: CLIENT -> SERVER: AUTH LOGIN\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1785', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"334 VXNlcm5hbWU6\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1786', '2022-01-20 06:18:20', 'SMTP Debug: SERVER -> CLIENT: 334 VXNlcm5hbWU6\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1787', '2022-01-20 06:18:20', 'SMTP Debug: CLIENT -> SERVER: bXJvZmlxNDY2QGdtYWlsLmNvbQ==\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1788', '2022-01-20 06:18:20', 'SMTP Debug: SMTP INBOUND: \"334 UGFzc3dvcmQ6\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1789', '2022-01-20 06:18:20', 'SMTP Debug: SERVER -> CLIENT: 334 UGFzc3dvcmQ6\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1790', '2022-01-20 06:18:20', 'SMTP Debug: CLIENT -> SERVER: I01yQDIxMzM0NjU1\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1791', '2022-01-20 06:18:22', 'SMTP Debug: SMTP INBOUND: \"535 Incorrect authentication data\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1792', '2022-01-20 06:18:22', 'SMTP Debug: SERVER -> CLIENT: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1793', '2022-01-20 06:18:22', 'SMTP Debug: SMTP ERROR: Password command failed: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1794', '2022-01-20 06:18:22', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1795', '2022-01-20 06:18:22', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1796', '2022-01-20 06:18:22', 'SMTP Debug: SMTP INBOUND: \"221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1797', '2022-01-20 06:18:22', 'SMTP Debug: SERVER -> CLIENT: 221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1798', '2022-01-20 06:18:22', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1799', '2022-01-20 06:18:22', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1800', '2022-01-20 06:18:26', 'SMTP Debug: Connection: opening to ssl://smtp.gmail.com:25, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1801', '2022-01-20 06:18:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1802', '2022-01-20 06:18:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1803', '2022-01-20 06:18:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://smtp.gmail.com:25 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1804', '2022-01-20 06:18:26', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1805', '2022-01-20 06:18:26', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1806', '2022-01-20 06:18:30', 'SMTP Debug: Connection: opening to smtp.gmail.com:25, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1807', '2022-01-20 06:18:30', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1808', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:18:30 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1809', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1810', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1811', '2022-01-20 06:18:30', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:18:30 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1812', '2022-01-20 06:18:30', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1813', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1814', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1815', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1816', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1817', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1818', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1819', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1820', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1821', '2022-01-20 06:18:30', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1822', '2022-01-20 06:18:30', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1823', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1824', '2022-01-20 06:18:30', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1825', '2022-01-20 06:18:30', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1826', '2022-01-20 06:18:30', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1827', '2022-01-20 06:18:30', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1828', '2022-01-20 06:18:30', 'SMTP Debug: SMTP INBOUND: \"\0?wZtzL??i5ձ?2`?t221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1829', '2022-01-20 06:18:30', 'SMTP Debug: SERVER -> CLIENT: \0?wZtzL??i5ձ?2`?t221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1830', '2022-01-20 06:18:30', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0?wZtzL??i5ձ?2`?t221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1831', '2022-01-20 06:18:30', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1832', '2022-01-20 06:18:30', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.216');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1833', '2022-01-20 06:20:26', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1834', '2022-01-20 06:20:26', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1835', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:20:26 +0700\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1836', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1837', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1838', '2022-01-20 06:20:26', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:20:26 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1839', '2022-01-20 06:20:26', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1840', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1841', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1842', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1843', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1844', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1845', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1846', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1847', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1848', '2022-01-20 06:20:26', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1849', '2022-01-20 06:20:26', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1850', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1851', '2022-01-20 06:20:26', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1852', '2022-01-20 06:20:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1853', '2022-01-20 06:20:26', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1854', '2022-01-20 06:20:26', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1855', '2022-01-20 06:20:26', 'SMTP Debug: SMTP INBOUND: \"\0?f????<P3X(?\"\r???221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1856', '2022-01-20 06:20:26', 'SMTP Debug: SERVER -> CLIENT: \0?f????<P3X(?\"\r???221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1857', '2022-01-20 06:20:26', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0?f????<P3X(?\"\r???221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1858', '2022-01-20 06:20:26', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1859', '2022-01-20 06:20:26', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1860', '2022-01-20 06:20:41', 'SMTP Debug: Connection: opening to ssl://smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1861', '2022-01-20 06:20:41', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1862', '2022-01-20 06:20:41', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1863', '2022-01-20 06:20:41', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://smtp.gmail.com:587 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1864', '2022-01-20 06:20:41', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1865', '2022-01-20 06:20:41', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1866', '2022-01-20 06:20:47', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1867', '2022-01-20 06:20:47', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1868', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:20:47 +0700\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1869', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1870', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1871', '2022-01-20 06:20:47', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:20:47 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1872', '2022-01-20 06:20:47', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1873', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1874', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1875', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1876', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1877', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1878', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1879', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1880', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1881', '2022-01-20 06:20:47', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1882', '2022-01-20 06:20:47', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1883', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1884', '2022-01-20 06:20:47', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1885', '2022-01-20 06:20:47', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1886', '2022-01-20 06:20:47', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1887', '2022-01-20 06:20:47', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1888', '2022-01-20 06:20:47', 'SMTP Debug: SMTP INBOUND: \"\0>?q?W\"]??1*??sHi221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1889', '2022-01-20 06:20:47', 'SMTP Debug: SERVER -> CLIENT: \0>?q?W\"]??1*??sHi221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1890', '2022-01-20 06:20:47', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0>?q?W\"]??1*??sHi221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1891', '2022-01-20 06:20:47', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1892', '2022-01-20 06:20:47', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1893', '2022-01-20 06:35:25', 'SMTP Debug: Connection: opening to ssl://smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1894', '2022-01-20 06:35:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1895', '2022-01-20 06:35:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1896', '2022-01-20 06:35:26', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://smtp.gmail.com:587 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1897', '2022-01-20 06:35:26', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1898', '2022-01-20 06:35:26', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1899', '2022-01-20 06:35:30', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1900', '2022-01-20 06:35:30', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1901', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:35:30 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1902', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1903', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1904', '2022-01-20 06:35:30', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:35:30 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1905', '2022-01-20 06:35:30', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1906', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1907', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1908', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1909', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1910', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1911', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1912', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1913', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1914', '2022-01-20 06:35:30', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1915', '2022-01-20 06:35:30', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1916', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1917', '2022-01-20 06:35:30', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1918', '2022-01-20 06:35:30', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1919', '2022-01-20 06:35:30', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1920', '2022-01-20 06:35:30', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1921', '2022-01-20 06:35:30', 'SMTP Debug: SMTP INBOUND: \"\0?<$}?-??j??Kɩ?l1221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1922', '2022-01-20 06:35:30', 'SMTP Debug: SERVER -> CLIENT: \0?<$}?-??j??Kɩ?l1221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1923', '2022-01-20 06:35:30', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0?<$}?-??j??Kɩ?l1221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1924', '2022-01-20 06:35:30', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1925', '2022-01-20 06:35:30', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.72');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1926', '2022-01-20 06:37:33', 'SMTP Debug: Connection: opening to ssl://smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1927', '2022-01-20 06:37:33', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1928', '2022-01-20 06:37:33', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1929', '2022-01-20 06:37:33', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://smtp.gmail.com:587 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1930', '2022-01-20 06:37:33', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1931', '2022-01-20 06:37:33', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1932', '2022-01-20 06:37:37', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1933', '2022-01-20 06:37:37', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1934', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:37:37 +0700\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1935', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1936', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1937', '2022-01-20 06:37:37', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:37:37 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1938', '2022-01-20 06:37:37', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1939', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1940', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1941', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1942', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1943', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1944', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1945', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1946', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1947', '2022-01-20 06:37:37', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1948', '2022-01-20 06:37:37', 'SMTP Debug: Auth method requested: XOAUTH2', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1949', '2022-01-20 06:37:37', 'SMTP Debug: Auth methods available on the server: PLAIN,LOGIN', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1950', '2022-01-20 06:37:37', 'SMTP Debug: Requested auth method not available: XOAUTH2', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1951', '2022-01-20 06:37:37', 'SMTP Debug: Auth method selected: LOGIN', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1952', '2022-01-20 06:37:37', 'SMTP Debug: CLIENT -> SERVER: AUTH LOGIN\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1953', '2022-01-20 06:37:37', 'SMTP Debug: SMTP INBOUND: \"334 VXNlcm5hbWU6\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1954', '2022-01-20 06:37:37', 'SMTP Debug: SERVER -> CLIENT: 334 VXNlcm5hbWU6\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1955', '2022-01-20 06:37:37', 'SMTP Debug: CLIENT -> SERVER: \r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1956', '2022-01-20 06:37:39', 'SMTP Debug: SMTP INBOUND: \"535 Incorrect authentication data\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1957', '2022-01-20 06:37:39', 'SMTP Debug: SERVER -> CLIENT: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1958', '2022-01-20 06:37:39', 'SMTP Debug: SMTP ERROR: Username command failed: 535 Incorrect authentication data\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1959', '2022-01-20 06:37:39', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1960', '2022-01-20 06:37:39', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1961', '2022-01-20 06:37:39', 'SMTP Debug: SMTP INBOUND: \"221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1962', '2022-01-20 06:37:39', 'SMTP Debug: SERVER -> CLIENT: 221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1963', '2022-01-20 06:37:39', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1964', '2022-01-20 06:37:39', 'SMTP Debug: SMTP Error: Could not authenticate.', 'rofiq', '0', '0', '1', '172.70.143.9');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1965', '2022-01-20 06:38:52', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1966', '2022-01-20 06:38:52', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1967', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:38:52 +0700\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1968', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1969', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1970', '2022-01-20 06:38:52', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:38:52 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1971', '2022-01-20 06:38:52', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1972', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1973', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1974', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1975', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1976', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1977', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1978', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1979', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1980', '2022-01-20 06:38:52', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1981', '2022-01-20 06:38:52', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1982', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1983', '2022-01-20 06:38:52', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1984', '2022-01-20 06:38:52', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1985', '2022-01-20 06:38:52', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1986', '2022-01-20 06:38:52', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1987', '2022-01-20 06:38:52', 'SMTP Debug: SMTP INBOUND: \"\0?S???\'\r=?a??\r??6?221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1988', '2022-01-20 06:38:52', 'SMTP Debug: SERVER -> CLIENT: \0?S???\'\r=?a??\r??6?221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1989', '2022-01-20 06:38:52', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0?S???\'\r=?a??\r??6?221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1990', '2022-01-20 06:38:52', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1991', '2022-01-20 06:38:52', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.163.23');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1992', '2022-01-20 06:41:36', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1993', '2022-01-20 06:41:36', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1994', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:41:36 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1995', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1996', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1997', '2022-01-20 06:41:36', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:41:36 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1998', '2022-01-20 06:41:36', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('1999', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2000', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2001', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2002', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2003', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2004', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2005', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2006', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2007', '2022-01-20 06:41:36', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2008', '2022-01-20 06:41:36', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2009', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2010', '2022-01-20 06:41:36', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2011', '2022-01-20 06:41:36', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2012', '2022-01-20 06:41:36', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2013', '2022-01-20 06:41:36', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2014', '2022-01-20 06:41:36', 'SMTP Debug: SMTP INBOUND: \"\0??`?Xll???Ʀ???l221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2015', '2022-01-20 06:41:36', 'SMTP Debug: SERVER -> CLIENT: \0??`?Xll???Ʀ???l221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2016', '2022-01-20 06:41:36', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0??`?Xll???Ʀ???l221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2017', '2022-01-20 06:41:36', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2018', '2022-01-20 06:41:36', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2019', '2022-01-20 06:41:37', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2020', '2022-01-20 06:41:37', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2021', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:41:37 +0700\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2022', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2023', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2024', '2022-01-20 06:41:37', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:41:37 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2025', '2022-01-20 06:41:37', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2026', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2027', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2028', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2029', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2030', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2031', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2032', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2033', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2034', '2022-01-20 06:41:37', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2035', '2022-01-20 06:41:37', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2036', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2037', '2022-01-20 06:41:37', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2038', '2022-01-20 06:41:37', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2039', '2022-01-20 06:41:37', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2040', '2022-01-20 06:41:37', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2041', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \"\0p*???_??\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2042', '2022-01-20 06:41:37', 'SMTP Debug: SMTP INBOUND: \":5?}?̄221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2043', '2022-01-20 06:41:37', 'SMTP Debug: SERVER -> CLIENT: \0p*???_??\n:5?}?̄221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2044', '2022-01-20 06:41:37', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0p*???_??\n:5?}?̄221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2045', '2022-01-20 06:41:37', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2046', '2022-01-20 06:41:37', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '162.158.162.152');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2047', '2022-01-20 06:42:38', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2048', '2022-01-20 06:42:38', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2049', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:42:38 +0700\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2050', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2051', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2052', '2022-01-20 06:42:38', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:42:38 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2053', '2022-01-20 06:42:38', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2054', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2055', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2056', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2057', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2058', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2059', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2060', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2061', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2062', '2022-01-20 06:42:38', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2063', '2022-01-20 06:42:38', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2064', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2065', '2022-01-20 06:42:38', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2066', '2022-01-20 06:42:38', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2067', '2022-01-20 06:42:38', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2068', '2022-01-20 06:42:38', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2069', '2022-01-20 06:42:38', 'SMTP Debug: SMTP INBOUND: \"\0zG??ͬ?>Ǘ???k221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2070', '2022-01-20 06:42:38', 'SMTP Debug: SERVER -> CLIENT: \0zG??ͬ?>Ǘ???k221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2071', '2022-01-20 06:42:38', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0zG??ͬ?>Ǘ???k221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2072', '2022-01-20 06:42:38', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2073', '2022-01-20 06:42:38', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2074', '2022-01-20 06:43:45', 'General Settings Modified. Changes made: Display Errors Enabled. Log Errors Enabled.', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2075', '2022-01-20 06:44:34', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2076', '2022-01-20 06:44:34', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2077', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:44:34 +0700\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2078', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2079', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2080', '2022-01-20 06:44:34', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:44:34 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2081', '2022-01-20 06:44:34', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2082', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2083', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2084', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2085', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2086', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2087', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2088', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2089', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2090', '2022-01-20 06:44:34', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2091', '2022-01-20 06:44:34', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2092', '2022-01-20 06:44:34', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2093', '2022-01-20 06:44:34', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2094', '2022-01-20 06:44:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2095', '2022-01-20 06:44:35', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2096', '2022-01-20 06:44:35', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2097', '2022-01-20 06:44:35', 'SMTP Debug: SMTP INBOUND: \"\0???)đ+A??dF?9??221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2098', '2022-01-20 06:44:35', 'SMTP Debug: SERVER -> CLIENT: \0???)đ+A??dF?9??221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2099', '2022-01-20 06:44:35', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0???)đ+A??dF?9??221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2100', '2022-01-20 06:44:35', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2101', '2022-01-20 06:44:35', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2102', '2022-01-20 06:45:35', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2103', '2022-01-20 06:45:35', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2104', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:45:35 +0700\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2105', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2106', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2107', '2022-01-20 06:45:35', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:45:35 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2108', '2022-01-20 06:45:35', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2109', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2110', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2111', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2112', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2113', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2114', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2115', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2116', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2117', '2022-01-20 06:45:35', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2118', '2022-01-20 06:45:35', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2119', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2120', '2022-01-20 06:45:35', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2121', '2022-01-20 06:45:35', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2122', '2022-01-20 06:45:35', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2123', '2022-01-20 06:45:35', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2124', '2022-01-20 06:45:35', 'SMTP Debug: SMTP INBOUND: \"\0??hx=?????p.??d221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2125', '2022-01-20 06:45:35', 'SMTP Debug: SERVER -> CLIENT: \0??hx=?????p.??d221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2126', '2022-01-20 06:45:35', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0??hx=?????p.??d221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2127', '2022-01-20 06:45:35', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2128', '2022-01-20 06:45:35', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2129', '2022-01-20 06:47:57', 'SMTP Debug: Connection: opening to smtp.gmail.com:587, timeout=300, options=array()', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2130', '2022-01-20 06:47:57', 'SMTP Debug: Connection: opened', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2131', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:47:57 +0700\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2132', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"220-We do not authorize the use of this system to transport unsolicited,\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2133', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"220 and/or bulk e-mail.\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2134', '2022-01-20 06:47:57', 'SMTP Debug: SERVER -> CLIENT: 220-vm03202109.i3cloud.co.id ESMTP Exim 4.94.2 #2 Thu, 20 Jan 2022 13:47:57 +0700 \r\n220-We do not authorize the use of this system to transport unsolicited, \r\n220 and/or bulk e-mail.\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2135', '2022-01-20 06:47:57', 'SMTP Debug: CLIENT -> SERVER: EHLO my.i3cloud.co.id\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2136', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2137', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-SIZE 52428800\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2138', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-8BITMIME\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2139', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-PIPELINING\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2140', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-PIPE_CONNECT\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2141', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-AUTH PLAIN LOGIN\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2142', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250-STARTTLS\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2143', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"250 HELP\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2144', '2022-01-20 06:47:57', 'SMTP Debug: SERVER -> CLIENT: 250-vm03202109.i3cloud.co.id Hello my.i3cloud.co.id [194.233.66.255]\r\n250-SIZE 52428800\r\n250-8BITMIME\r\n250-PIPELINING\r\n250-PIPE_CONNECT\r\n250-AUTH PLAIN LOGIN\r\n250-STARTTLS\r\n250 HELP\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2145', '2022-01-20 06:47:57', 'SMTP Debug: CLIENT -> SERVER: STARTTLS\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2146', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"220 TLS go ahead\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2147', '2022-01-20 06:47:57', 'SMTP Debug: SERVER -> CLIENT: 220 TLS go ahead\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2148', '2022-01-20 06:47:57', 'SMTP Debug: Connection failed. Error #2: stream_socket_enable_crypto(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`smtp.gmail.com\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 426]', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2149', '2022-01-20 06:47:57', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2150', '2022-01-20 06:47:57', 'SMTP Debug: CLIENT -> SERVER: QUIT\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2151', '2022-01-20 06:47:57', 'SMTP Debug: SMTP INBOUND: \"\0-Ժ0??gHٛ??T????S?221 vm03202109.i3cloud.co.id closing connection\"', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2152', '2022-01-20 06:47:57', 'SMTP Debug: SERVER -> CLIENT: \0-Ժ0??gHٛ??T????S?221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2153', '2022-01-20 06:47:57', 'SMTP Debug: SMTP ERROR: QUIT command failed: \0-Ժ0??gHٛ??T????S?221 vm03202109.i3cloud.co.id closing connection\r\n', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2154', '2022-01-20 06:47:57', 'SMTP Debug: Connection: closed', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2155', '2022-01-20 06:47:57', 'SMTP Debug: SMTP Error: Could not connect to SMTP host.', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2156', '2022-01-20 07:09:13', 'General Settings Modified. Changes made: Display Errors Disabled. Log Errors Disabled.', 'rofiq', '0', '0', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2157', '2022-01-20 07:10:12', 'General Settings Modified. Changes made: Domain Changed from \'http://my.i3cloud.co.id/\' to \'https://my.i3cloud.co.id/\'. System URL Changed from \'http://my.i3cloud.co.id/\' to \'https://my.i3cloud.co.id/\'.', 'rofiq', '0', '0', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2158', '2022-01-20 07:10:28', 'General Settings Modified. Changes made: Email Changed from \'log.i3cloud@gmail.com\' to \'customercare@i3cloud.id\'.', 'rofiq', '0', '0', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2159', '2022-01-20 07:10:55', 'General Settings Modified. Changes made: System Emails From Email Changed from \'noreply@my.i3cloud.co.id\' to \'customercare@i3cloud.id\'.', 'rofiq', '0', '0', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2160', '2022-01-20 07:12:19', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2161', '2022-01-20 07:13:50', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2162', '2022-01-20 07:15:20', 'General Settings Modified. Changes made: Domain Changed from \'http://my.i3cloud.co.id\' to \'http://my.i3cloud.co.id/\'. Signature Changed. System Emails From Email Changed from \'noreply@my.i3cloud.co.id\' to \'customercare@i3cloud.id\'.', 'rofiq', '0', '1', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2163', '2022-01-20 07:16:00', 'General Settings Modified. Changes made: Domain Changed from \'http://my.i3cloud.co.id/\' to \'https://my.i3cloud.co.id/\'. System URL Changed from \'http://my.i3cloud.co.id/\' to \'https://my.i3cloud.co.id/\'.', 'rofiq', '0', '1', '1', '172.70.142.8');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2164', '2022-01-20 08:43:54', 'Verification Email Resent', 'mrofiq990@gmail.com', '1', '1', '0', '162.158.162.98');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2165', '2022-01-20 08:54:16', 'Admin User \'robot\' modified. Changes: Email changed from \'log.i3cloud@gmail.com\' to \'customercare@i3cloud.id\'. Password Changed', 'rofiq', '0', '1', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2166', '2022-01-20 08:54:25', 'Admin User \'robot\' modified. Changes: Added Support Departments Notification: General Enquiries. Password Changed', 'rofiq', '0', '1', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2167', '2022-01-20 08:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2168', '2022-01-20 08:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2169', '2022-01-20 08:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2170', '2022-01-20 08:55:07', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2171', '2022-01-20 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2172', '2022-01-20 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2173', '2022-01-20 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2174', '2022-01-20 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2175', '2022-01-20 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2176', '2022-01-20 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2177', '2022-01-20 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2178', '2022-01-20 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2179', '2022-01-20 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2180', '2022-01-20 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2181', '2022-01-20 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2182', '2022-01-20 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2183', '2022-01-20 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2184', '2022-01-20 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2185', '2022-01-20 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2186', '2022-01-20 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2187', '2022-01-20 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2188', '2022-01-20 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2189', '2022-01-20 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2190', '2022-01-20 09:00:05', 'Server Usage Update Failed: Access denied - Server ID: 2', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2191', '2022-01-20 09:00:06', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2192', '2022-01-20 09:00:06', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2193', '2022-01-20 09:00:06', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2194', '2022-01-20 09:00:06', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2195', '2022-01-20 09:00:06', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2196', '2022-01-20 09:00:06', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2197', '2022-01-20 09:00:07', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2198', '2022-01-20 09:07:25', 'General Settings Modified. Changes made: Display Errors Enabled. Log Errors Enabled.', 'rofiq', '0', '1', '1', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2199', '2022-01-20 09:10:21', 'General Settings Modified. Changes made: Email Changed from \'customercare@i3cloud.id\' to \'log.i3cloud@gmail.com\'.', 'rofiq', '0', '1', '1', '162.158.163.145');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2200', '2022-01-20 09:10:44', 'Verification Email Resent', 'rofiq', '0', '1', '1', '162.158.163.145');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2201', '2022-01-20 09:11:50', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2202', '2022-01-20 09:12:42', 'General Settings Modified. Changes made: Email Changed from \'log.i3cloud@gmail.com\' to \'i3cloud@gmail.com\'.', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2203', '2022-01-20 09:12:57', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2204', '2022-01-20 09:13:34', 'General Settings Modified. Changes made: Email Changed from \'i3cloud@gmail.com\' to \'customercare@i3cloud.id\'.', 'rofiq', '0', '1', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2205', '2022-01-20 09:13:44', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2206', '2022-01-20 09:14:06', 'General Settings Modified. Changes made: Email Changed from \'customercare@i3cloud.id\' to \'customercare@google.com\'.', 'rofiq', '0', '1', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2207', '2022-01-20 09:14:14', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.143.43');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2208', '2022-01-20 09:14:49', 'General Settings Modified. Changes made: Email Changed from \'customercare@google.com\' to \'log.i3cloud@gmail.com\'.', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2209', '2022-01-20 09:15:42', 'General Settings Modified. Changes made: System Emails From Email Changed from \'customercare@i3cloud.id\' to \'log.i3cloud@gmail.com\'.', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2210', '2022-01-20 09:16:07', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2211', '2022-01-20 09:19:38', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.147.100');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2212', '2022-01-20 09:21:02', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2213', '2022-01-20 09:22:16', 'Email Sent to Muhammad Rofiq (Welcome)  - User ID: 1', 'rofiq', '1', '1', '1', '172.70.147.182');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2214', '2022-01-20 09:23:22', 'Email Sent to Muhammad Rofiq (New Product Information)  - User ID: 1', 'rofiq', '1', '1', '1', '172.70.147.100');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2215', '2022-01-20 09:33:32', 'General Settings Modified. Changes made: Display Errors Disabled. Log Errors Disabled.', 'rofiq', '0', '1', '1', '162.158.163.37');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2216', '2022-01-20 09:34:21', 'Addon Module Settings Modified - Liquid Upload Documents  - Recaptcha Public Key: \'6LcwPyIeAAAAALImxP-9-wsa9uWS-79tBqAJKTH4\' to \'6LdShiUeAAAAAIwRWqZQVDWWwCwGUQ5AFe2W7ttY\', Recaptcha Secret Key: \'6LcwPyIeAAAAADOGl8xKT7Nfa9nfyOy7PUMW772Y\' to \'6LdShiUeAAAAAOCbG8YHL4dE7doZA28KIc1asG6I\'', 'rofiq', '0', '1', '1', '162.158.163.109');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2217', '2022-01-20 09:35:01', 'Admin User \'robot\' modified. Changes: Email changed from \'customercare@i3cloud.id\' to \'log.i3cloud@gmail.com\'. Password Changed', 'rofiq', '0', '1', '1', '162.158.163.109');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2218', '2022-01-20 11:23:19', 'Addon Module Activated - Liquid DNSSEC', 'rofiq', '0', '0', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2219', '2022-01-20 11:26:08', 'Addon Module Access Permissions Changed - Liquid DNSSEC -  Added Role Group(s): Full Administrator.', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2220', '2022-01-20 11:26:08', 'Addon Module Settings Modified - Liquid DNSSEC  - Initial setting of ResellerID on Liqu.id to \'\', Apikey on Liqu.id (password field) value set., Initial setting of ResellerID on ResellerCamp.id to \'11511\', Apikey on ResellerCamp.id (password field) value set., Initial setting of TestMode to \'\'', 'rofiq', '0', '0', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2221', '2022-01-20 11:44:57', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.28');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2222', '2022-01-20 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2223', '2022-01-20 12:55:09', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2224', '2022-01-20 12:55:09', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2225', '2022-01-20 12:55:10', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2226', '2022-01-20 14:01:29', 'SMTP Debug: Connection: opening to ssl://esa25.sophos.id:587, timeout=300, options=array()', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2227', '2022-01-20 14:01:29', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2228', '2022-01-20 14:01:29', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2229', '2022-01-20 14:01:29', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://esa25.sophos.id:587 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2230', '2022-01-20 14:01:29', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2231', '2022-01-20 14:01:29', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2232', '2022-01-20 14:01:34', 'SMTP Debug: Connection: opening to ssl://esa25.sophos.id:587, timeout=300, options=array()', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2233', '2022-01-20 14:01:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2234', '2022-01-20 14:01:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2235', '2022-01-20 14:01:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://esa25.sophos.id:587 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2236', '2022-01-20 14:01:34', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2237', '2022-01-20 14:01:34', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2238', '2022-01-20 14:01:37', 'SMTP Debug: Connection: opening to ssl://esa25.sophos.id:25, timeout=300, options=array()', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2239', '2022-01-20 14:01:37', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): SSL operation failed with code 1. OpenSSL Error messages:\nerror:1408F10B:SSL routines:ssl3_get_record:wrong version number [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2240', '2022-01-20 14:01:37', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2241', '2022-01-20 14:01:37', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://esa25.sophos.id:25 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2242', '2022-01-20 14:01:37', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2243', '2022-01-20 14:01:37', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'admin', '0', '0', '3', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2244', '2022-01-20 14:32:33', 'General Settings Modified. Changes made: Signature Changed. System Emails From Email Changed from \'log.i3cloud@gmail.com\' to \'customercare@i3cloud.id\'.', 'admin', '0', '0', '3', '172.70.142.110');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2245', '2022-01-20 14:57:04', 'SMTP Debug: Connection: opening to ssl://esa25.sophos.id:465, timeout=300, options=array()', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2246', '2022-01-20 14:57:04', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`esa25.sophos.id\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2247', '2022-01-20 14:57:04', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2248', '2022-01-20 14:57:04', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://esa25.sophos.id:465 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2249', '2022-01-20 14:57:04', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2250', '2022-01-20 14:57:04', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2251', '2022-01-20 14:59:32', 'SMTP Debug: Connection: opening to ssl://esa25.sophos.id:465, timeout=300, options=array()', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2252', '2022-01-20 14:59:32', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`esa25.sophos.id\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2253', '2022-01-20 14:59:32', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2254', '2022-01-20 14:59:32', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://esa25.sophos.id:465 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2255', '2022-01-20 14:59:32', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2256', '2022-01-20 14:59:32', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2257', '2022-01-20 14:59:34', 'SMTP Debug: Connection: opening to ssl://esa25.sophos.id:465, timeout=300, options=array()', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2258', '2022-01-20 14:59:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Peer certificate CN=`vm03202109.i3cloud.co.id\' did not match expected CN=`esa25.sophos.id\' [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2259', '2022-01-20 14:59:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): Failed to enable crypto [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2260', '2022-01-20 14:59:34', 'SMTP Debug: Connection failed. Error #2: stream_socket_client(): unable to connect to ssl://esa25.sophos.id:465 (Unknown error) [/home/i3cloudcoid/public_html/whmcs/vendor/phpmailer/phpmailer/src/SMTP.php line 344]', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2261', '2022-01-20 14:59:34', 'SMTP Debug: SMTP ERROR: Failed to connect to server:  (0)', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2262', '2022-01-20 14:59:34', 'SMTP Debug: SMTP connect() failed. https://github.com/PHPMailer/PHPMailer/wiki/Troubleshooting', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2263', '2022-01-20 15:48:12', 'Mail Provider Configuration Modified: \'SMTP\' - Mail Provider SMTP Activated. \'service_provider\' set to \'Generic\'. \'host\' set to \'esa25.sophos.id\'. \'port\' set to \'465\'. \'auth_type\' set to \'plain\'. \'username\' set to \'whmcs\'. \'secure\' set to \'ssl\'.', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2264', '2022-01-20 15:49:12', 'Mail Provider Configuration Modified: \'SMTP\' - \'oauth2_client_secret\' value modified. \'oauth2_refresh_token\' value modified.', 'admin', '0', '0', '3', '125.166.33.136');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2265', '2022-01-20 16:05:35', 'Mail Provider Configuration Modified: \'SMTP\' - \'service_provider\' set to \'Google\'. \'host\' set to \'smtp.gmail.com\'. \'auth_type\' set to \'oauth2\'. \'username\' set to \'customercare@i3cloud.id\'. \'oauth2_client_id\' set to \'418708715786-i9m9dhgj1m4lqoq9aiekbmgsbjp7quet.apps.googleusercontent.com\'. \'oauth2_client_secret\' value modified. \'oauth2_refresh_token\' value modified.', 'admin', '0', '0', '3', '172.70.147.184');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2266', '2022-01-20 16:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2267', '2022-01-20 16:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2268', '2022-01-20 16:55:04', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2269', '2022-01-20 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2270', '2022-01-20 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2271', '2022-01-20 20:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2272', '2022-01-20 20:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2273', '2022-01-20 20:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2274', '2022-01-21 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2275', '2022-01-21 00:55:10', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2276', '2022-01-21 00:55:10', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2277', '2022-01-21 00:55:12', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2278', '2022-01-21 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2279', '2022-01-21 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2280', '2022-01-21 04:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2281', '2022-01-21 04:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2282', '2022-01-21 04:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2283', '2022-01-21 06:53:04', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.147.184');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2284', '2022-01-21 06:55:44', 'General Settings Modified. Changes made: Email Changed from \'log.i3cloud@gmail.com\' to \'customercare@i3cloud.id\'.', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2285', '2022-01-21 06:56:17', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2286', '2022-01-21 06:57:26', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.188.86');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2287', '2022-01-21 07:11:06', 'Verification Email Resent', 'rofiq', '0', '1', '1', '172.70.189.103');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2288', '2022-01-21 08:44:01', 'General Settings Modified. Changes made: Domain Changed from \'https://my.i3cloud.co.id/\' to \'https://dev.my.i3cloud.co.id/\'. Logo URL Changed from \'//my.i3cloud.co.id/assets/img/logo.jpg\' to \'//dev.my.i3cloud.co.id/assets/img/logo.jpg\'. System URL Changed from \'https://my.i3cloud.co.id/\' to \'https://dev.my.i3cloud.co.id/\'.', 'rofiq', '0', '0', '1', '162.158.163.29');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2289', '2022-01-21 08:46:12', 'Updated URI Path Mode to: rewrite', 'rofiq', '0', '0', '1', '172.70.142.254');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2290', '2022-01-21 08:46:12', 'Uri Path Management Setting \"URI Mode Override\" Disabled', 'rofiq', '0', '0', '1', '172.70.142.254');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2291', '2022-01-21 10:53:26', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2292', '2022-01-21 10:53:27', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2293', '2022-01-21 10:53:27', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2294', '2022-01-21 10:53:27', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2295', '2022-01-21 10:53:27', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2296', '2022-01-21 10:53:27', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2297', '2022-01-21 10:53:27', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2298', '2022-01-21 10:53:27', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2299', '2022-01-21 10:53:27', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2300', '2022-01-21 10:53:27', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2301', '2022-01-21 10:53:27', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2302', '2022-01-21 10:53:27', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2303', '2022-01-21 10:53:27', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2304', '2022-01-21 10:53:27', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2305', '2022-01-21 10:53:27', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2306', '2022-01-21 10:53:27', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2307', '2022-01-21 10:53:27', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2308', '2022-01-21 10:53:28', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2309', '2022-01-21 10:53:30', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2310', '2022-01-21 10:53:30', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2311', '2022-01-21 10:53:30', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2312', '2022-01-21 10:53:31', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2313', '2022-01-21 10:53:31', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2314', '2022-01-21 10:53:31', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2315', '2022-01-21 10:53:31', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2316', '2022-01-21 10:53:32', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2317', '2022-01-21 10:59:31', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2318', '2022-01-21 10:59:31', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2319', '2022-01-21 10:59:32', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2320', '2022-01-21 10:59:32', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2321', '2022-01-21 10:59:32', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2322', '2022-01-21 10:59:38', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2323', '2022-01-21 10:59:38', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2324', '2022-01-21 10:59:38', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2325', '2022-01-21 10:59:38', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2326', '2022-01-21 10:59:38', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2327', '2022-01-21 10:59:38', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2328', '2022-01-21 10:59:39', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2329', '2022-01-21 10:59:39', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2330', '2022-01-21 10:59:39', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2331', '2022-01-21 10:59:39', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2332', '2022-01-21 10:59:39', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2333', '2022-01-21 10:59:39', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2334', '2022-01-21 10:59:39', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2335', '2022-01-21 10:59:39', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2336', '2022-01-21 10:59:39', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2337', '2022-01-21 10:59:39', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2338', '2022-01-21 10:59:39', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2339', '2022-01-21 10:59:39', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2340', '2022-01-21 10:59:39', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2341', '2022-01-21 10:59:39', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2342', '2022-01-21 10:59:39', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2343', '2022-01-21 10:59:39', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2344', '2022-01-21 10:59:39', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2345', '2022-01-21 10:59:39', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2346', '2022-01-21 10:59:39', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2347', '2022-01-21 10:59:39', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2348', '2022-01-21 10:59:40', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2349', '2022-01-21 10:59:40', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2350', '2022-01-21 10:59:40', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2351', '2022-01-21 10:59:40', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2352', '2022-01-21 10:59:40', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2353', '2022-01-21 10:59:40', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2354', '2022-01-21 10:59:41', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2355', '2022-01-21 10:59:44', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2356', '2022-01-21 10:59:47', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2357', '2022-01-21 11:03:11', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2358', '2022-01-21 11:03:11', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2359', '2022-01-21 11:03:12', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2360', '2022-01-21 11:03:12', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2361', '2022-01-21 11:03:12', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2362', '2022-01-21 11:03:16', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2363', '2022-01-21 11:03:16', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2364', '2022-01-21 11:03:16', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2365', '2022-01-21 11:03:16', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2366', '2022-01-21 11:03:16', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2367', '2022-01-21 11:03:16', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2368', '2022-01-21 11:03:16', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2369', '2022-01-21 11:03:16', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2370', '2022-01-21 11:03:16', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2371', '2022-01-21 11:03:16', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2372', '2022-01-21 11:03:16', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2373', '2022-01-21 11:03:16', 'Automated Task: Starting Prune Ticket Attachments', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2374', '2022-01-21 11:03:16', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2375', '2022-01-21 11:03:16', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2376', '2022-01-21 11:03:16', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2377', '2022-01-21 11:03:16', 'Automated Task: Starting Process Email Campaigns', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2378', '2022-01-21 11:03:16', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2379', '2022-01-21 11:03:16', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2380', '2022-01-21 11:03:16', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2381', '2022-01-21 11:03:16', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2382', '2022-01-21 11:03:17', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2383', '2022-01-21 11:03:17', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2384', '2022-01-21 11:03:17', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2385', '2022-01-21 11:03:17', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2386', '2022-01-21 11:03:17', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2387', '2022-01-21 11:03:17', 'Automated Task: Starting Update Server Usage', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2388', '2022-01-21 11:03:17', 'Automated Task: Starting Update Server Meta Data', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2389', '2022-01-21 11:03:18', 'Automated Task: Starting Run Jobs Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2390', '2022-01-21 11:03:18', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2391', '2022-01-21 11:03:18', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2392', '2022-01-21 11:03:18', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2393', '2022-01-21 11:03:18', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2394', '2022-01-21 11:03:19', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2395', '2022-01-21 11:03:22', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2396', '2022-01-21 11:03:24', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2397', '2022-01-21 11:06:42', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 2', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2398', '2022-01-21 11:06:59', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 3', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2399', '2022-01-21 11:07:11', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 4', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2400', '2022-01-21 11:07:28', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 5', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2401', '2022-01-21 11:57:15', 'New Order Placed - Order ID: 5 - User ID: 1', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2402', '2022-01-21 11:57:15', 'Created Invoice - Invoice ID: 5', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2403', '2022-01-21 11:57:19', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2404', '2022-01-21 11:57:22', 'Email Sent to Muhammad Rofiq (WHMCS New Order Notification) ', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2405', '2022-01-21 11:57:25', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2406', '2022-01-21 11:57:36', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2407', '2022-01-21 11:57:38', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2408', '2022-01-21 12:11:07', 'Gateway Module Configuration Modified: \'Duitku VA Permata\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2409', '2022-01-21 12:11:28', 'Gateway Module Configuration Modified: \'Duitku VA CIMB\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2410', '2022-01-21 12:11:53', 'Gateway Module Configuration Modified: \'Duitku VA ATM Bersama\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2411', '2022-01-21 12:12:06', 'Gateway Module Configuration Modified: \'Duitku VA MANDIRI Direct\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2412', '2022-01-21 12:12:20', 'Gateway Module Configuration Modified: \'Duitku VA BNI\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2413', '2022-01-21 12:12:32', 'Gateway Module Configuration Modified: \'Duitku ShopeePay Applink\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2414', '2022-01-21 12:12:43', 'Gateway Module Configuration Modified: \'Duitku QRIS by ShopeePay\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2415', '2022-01-21 12:13:14', 'Gateway Module Deactivated: Duitku QRIS by ShopeePay to Duitku LinkAja QRIS', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2416', '2022-01-21 12:13:34', 'Gateway Module Deactivated: Duitku LinkAja QRIS to Duitku LinkAja Applink', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2417', '2022-01-21 12:14:22', 'Gateway Module Configuration Modified: \'Duitku LinkAja Applink\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2418', '2022-01-21 12:14:58', 'Gateway Module Configuration Modified: \'Duitku DANA\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2419', '2022-01-21 12:15:09', 'Gateway Module Configuration Modified: \'Duitku Ovo\'', 'rofiq', '0', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2420', '2022-01-21 12:47:22', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2421', '2022-01-21 12:47:24', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '0', '1', '182.1.78.54');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2422', '2022-01-21 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2423', '2022-01-21 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2424', '2022-01-21 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2425', '2022-01-21 14:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2426', '2022-01-21 18:55:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2427', '2022-01-21 18:55:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2428', '2022-01-21 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2429', '2022-01-21 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2430', '2022-01-21 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2431', '2022-01-21 22:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2432', '2022-01-21 22:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2433', '2022-01-21 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2434', '2022-01-22 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2435', '2022-01-22 02:55:05', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2436', '2022-01-22 02:55:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2437', '2022-01-22 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2438', '2022-01-22 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2439', '2022-01-22 02:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2440', '2022-01-22 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2441', '2022-01-22 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2442', '2022-01-22 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2443', '2022-01-22 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2444', '2022-01-22 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2445', '2022-01-22 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2446', '2022-01-22 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2447', '2022-01-22 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2448', '2022-01-22 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2449', '2022-01-22 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2450', '2022-01-22 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2451', '2022-01-22 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2452', '2022-01-22 09:00:11', 'Email Sent to Muhammad Rofiq (First Invoice Overdue Notice)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2453', '2022-01-22 09:00:11', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2454', '2022-01-22 09:00:11', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2455', '2022-01-22 09:00:11', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2456', '2022-01-22 09:00:11', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2457', '2022-01-22 09:00:11', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2458', '2022-01-22 09:00:11', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2459', '2022-01-22 09:00:11', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2460', '2022-01-22 09:00:11', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2461', '2022-01-22 09:00:11', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2462', '2022-01-22 09:00:12', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2463', '2022-01-22 09:00:13', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2464', '2022-01-22 09:00:13', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2465', '2022-01-22 09:00:13', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2466', '2022-01-22 09:00:13', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2467', '2022-01-22 09:00:13', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2468', '2022-01-22 09:00:13', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2469', '2022-01-22 09:00:16', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2470', '2022-01-22 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2471', '2022-01-22 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2472', '2022-01-22 10:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2473', '2022-01-22 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2474', '2022-01-22 14:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2475', '2022-01-22 14:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2476', '2022-01-22 14:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2477', '2022-01-22 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2478', '2022-01-22 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2479', '2022-01-22 18:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2480', '2022-01-22 18:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2481', '2022-01-22 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2482', '2022-01-22 22:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2483', '2022-01-22 22:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2484', '2022-01-22 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2485', '2022-01-23 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2486', '2022-01-23 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2487', '2022-01-23 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2488', '2022-01-23 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2489', '2022-01-23 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2490', '2022-01-23 02:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2491', '2022-01-23 06:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2492', '2022-01-23 06:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2493', '2022-01-23 06:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2494', '2022-01-23 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2495', '2022-01-23 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2496', '2022-01-23 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2497', '2022-01-23 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2498', '2022-01-23 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2499', '2022-01-23 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2500', '2022-01-23 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2501', '2022-01-23 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2502', '2022-01-23 09:00:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2503', '2022-01-23 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2504', '2022-01-23 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2505', '2022-01-23 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2506', '2022-01-23 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2507', '2022-01-23 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2508', '2022-01-23 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2509', '2022-01-23 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2510', '2022-01-23 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2511', '2022-01-23 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2512', '2022-01-23 09:00:09', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2513', '2022-01-23 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2514', '2022-01-23 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2515', '2022-01-23 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2516', '2022-01-23 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2517', '2022-01-23 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2518', '2022-01-23 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2519', '2022-01-23 09:00:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2520', '2022-01-23 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2521', '2022-01-23 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2522', '2022-01-23 10:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2523', '2022-01-23 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2524', '2022-01-23 14:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2525', '2022-01-23 14:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2526', '2022-01-23 14:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2527', '2022-01-23 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2528', '2022-01-23 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2529', '2022-01-23 18:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2530', '2022-01-23 18:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2531', '2022-01-23 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2532', '2022-01-23 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2533', '2022-01-23 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2534', '2022-01-23 22:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2535', '2022-01-24 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2536', '2022-01-24 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2537', '2022-01-24 01:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2538', '2022-01-24 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2539', '2022-01-24 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2540', '2022-01-24 02:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2541', '2022-01-24 04:33:23', 'Created Client Amel Lia - User ID: 3', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2542', '2022-01-24 04:33:23', 'Opted Out from Marketing Emails - User ID: 3', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2543', '2022-01-24 04:33:26', 'Email Sent to Amel Lia (Welcome)  - User ID: 3', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2544', '2022-01-24 06:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2545', '2022-01-24 06:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2546', '2022-01-24 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2547', '2022-01-24 08:14:36', 'New Order Placed - Order ID: 6 - User ID: 3', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2548', '2022-01-24 08:14:36', 'Created Invoice - Invoice ID: 6', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2549', '2022-01-24 08:14:40', 'Email Sent to Amel Lia (Customer Invoice)  - User ID: 3', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2550', '2022-01-24 08:14:43', 'Email Sent to Amel Lia (WHMCS New Order Notification) ', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2551', '2022-01-24 08:14:45', 'Email Sent to Amel Lia (Order Confirmation)  - User ID: 3', 'menthe.cute@gmail.com', '3', '3', '0', '110.136.100.24');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2552', '2022-01-24 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2553', '2022-01-24 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2554', '2022-01-24 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2555', '2022-01-24 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2556', '2022-01-24 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2557', '2022-01-24 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2558', '2022-01-24 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2559', '2022-01-24 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2560', '2022-01-24 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2561', '2022-01-24 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2562', '2022-01-24 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2563', '2022-01-24 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2564', '2022-01-24 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2565', '2022-01-24 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2566', '2022-01-24 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2567', '2022-01-24 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2568', '2022-01-24 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2569', '2022-01-24 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2570', '2022-01-24 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2571', '2022-01-24 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2572', '2022-01-24 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2573', '2022-01-24 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2574', '2022-01-24 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2575', '2022-01-24 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2576', '2022-01-24 09:00:12', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2577', '2022-01-24 09:00:15', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2578', '2022-01-24 10:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2579', '2022-01-24 10:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2580', '2022-01-24 10:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2581', '2022-01-24 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2582', '2022-01-24 14:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2583', '2022-01-24 14:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2584', '2022-01-24 14:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2585', '2022-01-24 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2586', '2022-01-24 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2587', '2022-01-24 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2588', '2022-01-24 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2589', '2022-01-24 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2590', '2022-01-24 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2591', '2022-01-24 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2592', '2022-01-24 22:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2593', '2022-01-25 00:00:03', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2594', '2022-01-25 00:00:03', 'Cron Job: Sent 0 Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2595', '2022-01-25 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2596', '2022-01-25 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2597', '2022-01-25 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2598', '2022-01-25 02:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2599', '2022-01-25 02:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2600', '2022-01-25 02:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2601', '2022-01-25 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2602', '2022-01-25 06:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2603', '2022-01-25 06:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2604', '2022-01-25 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2605', '2022-01-25 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2606', '2022-01-25 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2607', '2022-01-25 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2608', '2022-01-25 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2609', '2022-01-25 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2610', '2022-01-25 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2611', '2022-01-25 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2612', '2022-01-25 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2613', '2022-01-25 09:00:09', 'Email Sent to Amel Lia (First Invoice Overdue Notice)  - User ID: 3', 'System', '3', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2614', '2022-01-25 09:00:09', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2615', '2022-01-25 09:00:09', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2616', '2022-01-25 09:00:09', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2617', '2022-01-25 09:00:09', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2618', '2022-01-25 09:00:09', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2619', '2022-01-25 09:00:09', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2620', '2022-01-25 09:00:09', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2621', '2022-01-25 09:00:09', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2622', '2022-01-25 09:00:09', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2623', '2022-01-25 09:00:11', 'Automated Task: Starting Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2624', '2022-01-25 09:00:11', 'Cron Job: Sent 0 Credit Card Expiry Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2625', '2022-01-25 09:00:11', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2626', '2022-01-25 09:00:13', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2627', '2022-01-25 09:00:13', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2628', '2022-01-25 09:00:13', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2629', '2022-01-25 09:00:13', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2630', '2022-01-25 09:00:13', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2631', '2022-01-25 09:00:13', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2632', '2022-01-25 09:00:16', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2633', '2022-01-25 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2634', '2022-01-25 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2635', '2022-01-25 10:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2636', '2022-01-25 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2637', '2022-01-25 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2638', '2022-01-25 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2639', '2022-01-25 14:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2640', '2022-01-25 17:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2641', '2022-01-25 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2642', '2022-01-25 18:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2643', '2022-01-25 18:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2644', '2022-01-25 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2645', '2022-01-25 22:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2646', '2022-01-25 22:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2647', '2022-01-25 22:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2648', '2022-01-26 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2649', '2022-01-26 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2650', '2022-01-26 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2651', '2022-01-26 02:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2652', '2022-01-26 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2653', '2022-01-26 02:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2654', '2022-01-26 04:23:52', 'Verification Email Resent', 'mrofiq990@gmail.com', '1', '1', '0', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2655', '2022-01-26 04:26:17', 'General Settings Modified. Changes made: Signature Changed.', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2656', '2022-01-26 04:27:37', 'Verification Email Resent', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2657', '2022-01-26 04:40:53', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2658', '2022-01-26 04:40:55', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2659', '2022-01-26 04:45:51', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2660', '2022-01-26 04:45:52', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2661', '2022-01-26 04:47:23', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2662', '2022-01-26 04:47:25', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2663', '2022-01-26 04:49:04', 'Product Configuration Modified: Automatic Setup Modified: \'Payment\' to \'Order\'. Product ID: 2', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2664', '2022-01-26 04:49:45', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2665', '2022-01-26 04:49:46', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2666', '2022-01-26 04:50:08', 'Product Configuration Modified: Automatic Setup Modified: \'Order\' to \'On\'. Product ID: 2', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2667', '2022-01-26 04:50:16', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2668', '2022-01-26 04:50:17', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2669', '2022-01-26 04:52:04', 'Server Modified: \'Server Indonesia\' - Changes: Maximum No. of Accounts Modified: \'200\' to \'50\' - Server ID: 2', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2670', '2022-01-26 04:53:28', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2671', '2022-01-26 04:53:29', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2672', '2022-01-26 05:03:33', 'Product Configuration Modified: Automatic Setup Modified: \'On\' to \'Payment\'. Product ID: 2', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2673', '2022-01-26 05:03:55', 'New Order Placed - Order ID: 7 - User ID: 1', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2674', '2022-01-26 05:03:55', 'Created Invoice - Invoice ID: 7', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2675', '2022-01-26 05:03:59', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2676', '2022-01-26 05:04:01', 'Email Sent to Muhammad Rofiq (WHMCS New Order Notification) ', 'rofiq', '0', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2677', '2022-01-26 05:04:04', 'Email Sent to Muhammad Rofiq (Order Confirmation)  - User ID: 1', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2678', '2022-01-26 05:04:08', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2679', '2022-01-26 05:04:09', 'Module Create Failed - Service ID: 6 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2680', '2022-01-26 05:04:17', 'Order Status set to Cancelled - Order ID: 7', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2681', '2022-01-26 05:04:17', 'Deleted Order - Order ID: 7', 'rofiq', '1', '1', '1', '182.1.74.112');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2682', '2022-01-26 05:52:16', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 2', 'rofiq', '0', '1', '1', '182.1.89.231');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2683', '2022-01-26 05:52:29', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 3', 'rofiq', '0', '1', '1', '182.1.89.231');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2684', '2022-01-26 05:52:41', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 4', 'rofiq', '0', '1', '1', '182.1.89.231');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2685', '2022-01-26 05:53:01', 'Product Configuration Modified: Server Group Modified: \'1\' to \'2\'. Product ID: 5', 'rofiq', '0', '1', '1', '182.1.89.231');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2686', '2022-01-26 06:37:58', 'Failed Admin Login Attempt - Username: admin', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2687', '2022-01-26 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2688', '2022-01-26 06:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2689', '2022-01-26 06:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2690', '2022-01-26 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2691', '2022-01-26 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2692', '2022-01-26 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2693', '2022-01-26 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2694', '2022-01-26 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2695', '2022-01-26 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2696', '2022-01-26 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2697', '2022-01-26 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2698', '2022-01-26 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2699', '2022-01-26 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2700', '2022-01-26 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2701', '2022-01-26 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2702', '2022-01-26 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2703', '2022-01-26 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2704', '2022-01-26 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2705', '2022-01-26 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2706', '2022-01-26 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2707', '2022-01-26 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2708', '2022-01-26 09:00:04', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2709', '2022-01-26 09:00:09', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2710', '2022-01-26 09:00:09', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2711', '2022-01-26 09:00:09', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2712', '2022-01-26 09:00:09', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2713', '2022-01-26 09:00:09', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2714', '2022-01-26 09:00:09', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2715', '2022-01-26 09:00:12', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2716', '2022-01-26 10:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2717', '2022-01-26 10:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2718', '2022-01-26 10:55:10', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2719', '2022-01-26 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2720', '2022-01-26 14:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2721', '2022-01-26 14:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2722', '2022-01-26 14:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2723', '2022-01-26 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2724', '2022-01-26 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2725', '2022-01-26 18:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2726', '2022-01-26 18:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2727', '2022-01-26 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2728', '2022-01-26 22:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2729', '2022-01-26 22:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2730', '2022-01-26 22:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2731', '2022-01-27 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2732', '2022-01-27 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2733', '2022-01-27 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2734', '2022-01-27 02:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2735', '2022-01-27 02:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2736', '2022-01-27 02:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2737', '2022-01-27 06:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2738', '2022-01-27 06:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2739', '2022-01-27 06:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2740', '2022-01-27 07:46:24', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '182.1.66.69');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2741', '2022-01-27 07:46:29', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '0', '1', '182.1.66.69');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2742', '2022-01-27 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2743', '2022-01-27 09:00:02', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2744', '2022-01-27 09:00:03', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2745', '2022-01-27 09:00:03', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2746', '2022-01-27 09:00:03', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2747', '2022-01-27 09:00:03', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2748', '2022-01-27 09:00:03', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2749', '2022-01-27 09:00:03', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2750', '2022-01-27 09:00:03', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2751', '2022-01-27 09:00:03', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2752', '2022-01-27 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2753', '2022-01-27 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2754', '2022-01-27 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2755', '2022-01-27 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2756', '2022-01-27 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2757', '2022-01-27 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2758', '2022-01-27 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2759', '2022-01-27 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2760', '2022-01-27 09:00:07', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2761', '2022-01-27 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2762', '2022-01-27 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2763', '2022-01-27 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2764', '2022-01-27 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2765', '2022-01-27 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2766', '2022-01-27 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2767', '2022-01-27 09:00:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2768', '2022-01-27 10:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2769', '2022-01-27 10:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2770', '2022-01-27 10:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2771', '2022-01-27 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2772', '2022-01-27 14:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2773', '2022-01-27 14:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2774', '2022-01-27 14:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2775', '2022-01-27 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2776', '2022-01-27 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2777', '2022-01-27 18:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2778', '2022-01-27 18:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2779', '2022-01-27 18:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2780', '2022-01-27 22:56:58', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2781', '2022-01-27 22:56:58', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2782', '2022-01-27 22:56:58', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2783', '2022-01-28 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2784', '2022-01-28 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2785', '2022-01-28 01:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2786', '2022-01-28 02:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2787', '2022-01-28 02:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2788', '2022-01-28 02:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2789', '2022-01-28 06:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2790', '2022-01-28 06:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2791', '2022-01-28 06:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2792', '2022-01-28 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2793', '2022-01-28 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2794', '2022-01-28 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2795', '2022-01-28 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2796', '2022-01-28 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2797', '2022-01-28 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2798', '2022-01-28 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2799', '2022-01-28 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2800', '2022-01-28 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2801', '2022-01-28 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2802', '2022-01-28 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2803', '2022-01-28 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2804', '2022-01-28 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2805', '2022-01-28 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2806', '2022-01-28 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2807', '2022-01-28 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2808', '2022-01-28 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2809', '2022-01-28 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2810', '2022-01-28 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2811', '2022-01-28 09:00:10', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2812', '2022-01-28 09:00:10', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2813', '2022-01-28 09:00:10', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2814', '2022-01-28 09:00:10', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2815', '2022-01-28 09:00:10', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2816', '2022-01-28 09:00:10', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2817', '2022-01-28 09:00:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2818', '2022-01-28 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2819', '2022-01-28 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2820', '2022-01-28 10:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2821', '2022-01-28 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2822', '2022-01-28 14:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2823', '2022-01-28 14:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2824', '2022-01-28 14:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2825', '2022-01-28 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2826', '2022-01-28 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2827', '2022-01-28 18:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2828', '2022-01-28 18:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2829', '2022-01-28 18:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2830', '2022-01-28 22:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2831', '2022-01-28 22:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2832', '2022-01-28 22:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2833', '2022-01-29 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2834', '2022-01-29 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2835', '2022-01-29 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2836', '2022-01-29 02:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2837', '2022-01-29 02:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2838', '2022-01-29 02:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2839', '2022-01-29 06:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2840', '2022-01-29 06:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2841', '2022-01-29 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2842', '2022-01-29 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2843', '2022-01-29 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2844', '2022-01-29 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2845', '2022-01-29 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2846', '2022-01-29 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2847', '2022-01-29 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2848', '2022-01-29 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2849', '2022-01-29 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2850', '2022-01-29 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2851', '2022-01-29 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2852', '2022-01-29 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2853', '2022-01-29 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2854', '2022-01-29 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2855', '2022-01-29 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2856', '2022-01-29 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2857', '2022-01-29 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2858', '2022-01-29 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2859', '2022-01-29 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2860', '2022-01-29 09:00:07', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2861', '2022-01-29 09:00:09', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2862', '2022-01-29 09:00:09', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2863', '2022-01-29 09:00:09', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2864', '2022-01-29 09:00:09', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2865', '2022-01-29 09:00:09', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2866', '2022-01-29 09:00:10', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2867', '2022-01-29 09:00:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2868', '2022-01-29 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2869', '2022-01-29 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2870', '2022-01-29 10:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2871', '2022-01-29 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2872', '2022-01-29 14:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2873', '2022-01-29 14:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2874', '2022-01-29 14:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2875', '2022-01-29 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2876', '2022-01-29 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2877', '2022-01-29 18:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2878', '2022-01-29 18:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2879', '2022-01-29 18:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2880', '2022-01-29 22:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2881', '2022-01-29 22:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2882', '2022-01-29 22:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2883', '2022-01-30 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2884', '2022-01-30 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2885', '2022-01-30 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2886', '2022-01-30 02:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2887', '2022-01-30 02:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2888', '2022-01-30 02:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2889', '2022-01-30 06:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2890', '2022-01-30 06:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2891', '2022-01-30 06:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2892', '2022-01-30 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2893', '2022-01-30 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2894', '2022-01-30 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2895', '2022-01-30 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2896', '2022-01-30 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2897', '2022-01-30 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2898', '2022-01-30 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2899', '2022-01-30 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2900', '2022-01-30 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2901', '2022-01-30 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2902', '2022-01-30 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2903', '2022-01-30 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2904', '2022-01-30 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2905', '2022-01-30 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2906', '2022-01-30 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2907', '2022-01-30 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2908', '2022-01-30 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2909', '2022-01-30 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2910', '2022-01-30 09:00:07', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2911', '2022-01-30 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2912', '2022-01-30 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2913', '2022-01-30 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2914', '2022-01-30 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2915', '2022-01-30 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2916', '2022-01-30 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2917', '2022-01-30 09:00:16', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2918', '2022-01-30 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2919', '2022-01-30 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2920', '2022-01-30 10:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2921', '2022-01-30 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2922', '2022-01-30 14:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2923', '2022-01-30 14:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2924', '2022-01-30 14:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2925', '2022-01-30 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2926', '2022-01-30 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2927', '2022-01-30 18:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2928', '2022-01-30 18:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2929', '2022-01-30 18:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2930', '2022-01-30 22:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2931', '2022-01-30 22:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2932', '2022-01-30 22:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2933', '2022-01-31 00:00:03', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2934', '2022-01-31 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2935', '2022-01-31 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2936', '2022-01-31 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2937', '2022-01-31 02:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2938', '2022-01-31 02:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2939', '2022-01-31 02:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2940', '2022-01-31 06:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2941', '2022-01-31 06:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2942', '2022-01-31 06:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2943', '2022-01-31 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2944', '2022-01-31 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2945', '2022-01-31 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2946', '2022-01-31 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2947', '2022-01-31 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2948', '2022-01-31 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2949', '2022-01-31 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2950', '2022-01-31 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2951', '2022-01-31 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2952', '2022-01-31 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2953', '2022-01-31 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2954', '2022-01-31 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2955', '2022-01-31 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2956', '2022-01-31 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2957', '2022-01-31 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2958', '2022-01-31 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2959', '2022-01-31 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2960', '2022-01-31 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2961', '2022-01-31 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2962', '2022-01-31 09:00:10', 'Automated Task: Starting Overage Billing Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2963', '2022-01-31 09:00:10', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2964', '2022-01-31 09:00:10', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2965', '2022-01-31 09:00:10', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2966', '2022-01-31 09:00:10', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2967', '2022-01-31 09:00:10', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2968', '2022-01-31 09:00:10', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2969', '2022-01-31 09:00:15', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2970', '2022-01-31 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2971', '2022-01-31 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2972', '2022-01-31 10:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2973', '2022-01-31 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2974', '2022-01-31 14:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2975', '2022-01-31 14:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2976', '2022-01-31 14:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2977', '2022-01-31 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2978', '2022-01-31 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2979', '2022-01-31 18:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2980', '2022-01-31 18:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2981', '2022-01-31 18:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2982', '2022-01-31 22:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2983', '2022-01-31 22:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2984', '2022-01-31 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2985', '2022-02-01 00:00:03', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2986', '2022-02-01 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2987', '2022-02-01 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2988', '2022-02-01 01:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2989', '2022-02-01 02:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2990', '2022-02-01 02:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2991', '2022-02-01 02:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2992', '2022-02-01 06:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2993', '2022-02-01 06:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2994', '2022-02-01 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2995', '2022-02-01 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2996', '2022-02-01 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2997', '2022-02-01 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2998', '2022-02-01 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('2999', '2022-02-01 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3000', '2022-02-01 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3001', '2022-02-01 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3002', '2022-02-01 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3003', '2022-02-01 09:00:04', 'Cron Job: 0 Expired Credit Cards Deleted', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3004', '2022-02-01 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3005', '2022-02-01 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3006', '2022-02-01 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3007', '2022-02-01 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3008', '2022-02-01 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3009', '2022-02-01 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3010', '2022-02-01 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3011', '2022-02-01 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3012', '2022-02-01 09:00:05', 'Automated Task: Starting Affiliate Reports', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3013', '2022-02-01 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3014', '2022-02-01 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3015', '2022-02-01 09:00:33', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3016', '2022-02-01 09:00:36', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3017', '2022-02-01 09:00:36', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3018', '2022-02-01 09:00:36', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3019', '2022-02-01 09:00:36', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3020', '2022-02-01 09:00:36', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3021', '2022-02-01 09:00:36', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3022', '2022-02-01 09:00:41', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3023', '2022-02-01 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3024', '2022-02-01 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3025', '2022-02-01 10:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3026', '2022-02-01 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3027', '2022-02-01 14:55:08', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3028', '2022-02-01 14:55:08', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3029', '2022-02-01 14:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3030', '2022-02-01 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3031', '2022-02-01 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3032', '2022-02-01 18:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3033', '2022-02-01 18:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3034', '2022-02-01 18:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3035', '2022-02-01 22:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3036', '2022-02-01 22:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3037', '2022-02-01 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3038', '2022-02-02 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3039', '2022-02-02 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3040', '2022-02-02 01:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3041', '2022-02-02 02:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3042', '2022-02-02 02:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3043', '2022-02-02 02:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3044', '2022-02-02 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3045', '2022-02-02 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3046', '2022-02-02 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3047', '2022-02-02 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3048', '2022-02-02 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3049', '2022-02-02 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3050', '2022-02-02 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3051', '2022-02-02 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3052', '2022-02-02 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3053', '2022-02-02 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3054', '2022-02-02 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3055', '2022-02-02 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3056', '2022-02-02 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3057', '2022-02-02 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3058', '2022-02-02 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3059', '2022-02-02 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3060', '2022-02-02 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3061', '2022-02-02 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3062', '2022-02-02 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3063', '2022-02-02 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3064', '2022-02-02 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3065', '2022-02-02 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3066', '2022-02-02 09:00:10', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3067', '2022-02-02 09:00:10', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3068', '2022-02-02 09:00:10', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3069', '2022-02-02 09:00:10', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3070', '2022-02-02 09:00:10', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3071', '2022-02-02 09:00:10', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3072', '2022-02-02 09:00:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3073', '2022-02-02 10:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3074', '2022-02-02 10:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3075', '2022-02-02 10:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3076', '2022-02-02 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3077', '2022-02-02 14:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3078', '2022-02-02 14:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3079', '2022-02-02 14:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3080', '2022-02-02 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3081', '2022-02-02 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3082', '2022-02-02 18:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3083', '2022-02-02 18:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3084', '2022-02-02 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3085', '2022-02-02 22:55:07', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3086', '2022-02-02 22:55:07', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3087', '2022-02-02 22:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3088', '2022-02-03 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3089', '2022-02-03 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3090', '2022-02-03 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3091', '2022-02-03 02:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3092', '2022-02-03 02:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3093', '2022-02-03 02:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3094', '2022-02-03 06:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3095', '2022-02-03 06:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3096', '2022-02-03 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3097', '2022-02-03 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3098', '2022-02-03 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3099', '2022-02-03 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3100', '2022-02-03 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3101', '2022-02-03 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3102', '2022-02-03 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3103', '2022-02-03 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3104', '2022-02-03 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3105', '2022-02-03 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3106', '2022-02-03 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3107', '2022-02-03 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3108', '2022-02-03 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3109', '2022-02-03 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3110', '2022-02-03 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3111', '2022-02-03 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3112', '2022-02-03 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3113', '2022-02-03 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3114', '2022-02-03 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3115', '2022-02-03 09:00:27', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3116', '2022-02-03 09:00:28', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3117', '2022-02-03 09:00:29', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3118', '2022-02-03 09:00:29', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3119', '2022-02-03 09:00:29', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3120', '2022-02-03 09:00:29', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3121', '2022-02-03 09:00:29', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3122', '2022-02-03 09:00:33', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3123', '2022-02-03 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3124', '2022-02-03 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3125', '2022-02-03 10:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3126', '2022-02-03 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3127', '2022-02-03 14:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3128', '2022-02-03 14:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3129', '2022-02-03 14:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3130', '2022-02-03 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3131', '2022-02-03 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3132', '2022-02-03 18:58:49', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3133', '2022-02-03 18:58:49', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3134', '2022-02-03 18:58:50', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3135', '2022-02-03 22:55:51', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3136', '2022-02-03 22:55:51', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3137', '2022-02-03 22:55:52', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3138', '2022-02-04 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3139', '2022-02-04 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3140', '2022-02-04 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3141', '2022-02-04 02:55:52', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3142', '2022-02-04 02:55:52', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3143', '2022-02-04 02:55:53', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3144', '2022-02-04 06:57:20', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3145', '2022-02-04 06:57:21', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3146', '2022-02-04 06:57:22', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3147', '2022-02-04 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3148', '2022-02-04 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3149', '2022-02-04 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3150', '2022-02-04 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3151', '2022-02-04 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3152', '2022-02-04 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3153', '2022-02-04 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3154', '2022-02-04 09:00:04', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3155', '2022-02-04 09:00:04', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3156', '2022-02-04 09:00:04', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3157', '2022-02-04 09:00:04', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3158', '2022-02-04 09:00:04', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3159', '2022-02-04 09:00:04', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3160', '2022-02-04 09:00:04', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3161', '2022-02-04 09:00:04', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3162', '2022-02-04 09:00:04', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3163', '2022-02-04 09:00:04', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3164', '2022-02-04 09:00:04', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3165', '2022-02-04 09:00:05', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3166', '2022-02-04 09:00:39', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3167', '2022-02-04 09:00:39', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3168', '2022-02-04 09:00:39', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3169', '2022-02-04 09:00:39', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3170', '2022-02-04 09:00:39', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3171', '2022-02-04 09:00:40', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3172', '2022-02-04 09:00:44', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3173', '2022-02-04 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3174', '2022-02-04 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3175', '2022-02-04 10:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3176', '2022-02-04 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3177', '2022-02-04 14:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3178', '2022-02-04 14:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3179', '2022-02-04 14:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3180', '2022-02-04 17:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3181', '2022-02-04 17:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3182', '2022-02-04 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3183', '2022-02-04 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3184', '2022-02-04 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3185', '2022-02-04 22:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3186', '2022-02-04 22:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3187', '2022-02-04 22:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3188', '2022-02-05 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3189', '2022-02-05 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3190', '2022-02-05 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3191', '2022-02-05 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3192', '2022-02-05 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3193', '2022-02-05 02:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3194', '2022-02-05 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3195', '2022-02-05 06:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3196', '2022-02-05 06:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3197', '2022-02-05 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3198', '2022-02-05 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3199', '2022-02-05 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3200', '2022-02-05 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3201', '2022-02-05 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3202', '2022-02-05 09:00:05', 'Created Invoice - Invoice ID: 8', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3203', '2022-02-05 09:00:10', 'Email Sent to Muhammad Rofiq (Customer Invoice)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3204', '2022-02-05 09:00:10', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3205', '2022-02-05 09:00:10', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3206', '2022-02-05 09:00:10', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3207', '2022-02-05 09:00:10', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3208', '2022-02-05 09:00:10', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3209', '2022-02-05 09:00:10', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3210', '2022-02-05 09:00:10', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3211', '2022-02-05 09:00:10', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3212', '2022-02-05 09:00:10', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3213', '2022-02-05 09:00:10', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3214', '2022-02-05 09:00:10', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3215', '2022-02-05 09:00:10', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3216', '2022-02-05 09:00:10', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3217', '2022-02-05 09:00:12', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3218', '2022-02-05 09:00:14', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3219', '2022-02-05 09:00:14', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3220', '2022-02-05 09:00:14', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3221', '2022-02-05 09:00:14', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3222', '2022-02-05 09:00:14', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3223', '2022-02-05 09:00:14', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3224', '2022-02-05 09:00:18', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3225', '2022-02-05 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3226', '2022-02-05 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3227', '2022-02-05 10:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3228', '2022-02-05 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3229', '2022-02-05 14:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3230', '2022-02-05 14:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3231', '2022-02-05 14:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3232', '2022-02-05 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3233', '2022-02-05 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3234', '2022-02-05 18:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3235', '2022-02-05 18:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3236', '2022-02-05 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3237', '2022-02-05 22:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3238', '2022-02-05 22:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3239', '2022-02-05 22:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3240', '2022-02-06 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3241', '2022-02-06 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3242', '2022-02-06 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3243', '2022-02-06 02:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3244', '2022-02-06 02:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3245', '2022-02-06 02:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3246', '2022-02-06 06:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3247', '2022-02-06 06:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3248', '2022-02-06 06:55:04', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3249', '2022-02-06 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3250', '2022-02-06 09:00:03', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3251', '2022-02-06 09:00:04', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3252', '2022-02-06 09:00:04', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3253', '2022-02-06 09:00:04', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3254', '2022-02-06 09:00:04', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3255', '2022-02-06 09:00:04', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3256', '2022-02-06 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3257', '2022-02-06 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3258', '2022-02-06 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3259', '2022-02-06 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3260', '2022-02-06 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3261', '2022-02-06 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3262', '2022-02-06 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3263', '2022-02-06 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3264', '2022-02-06 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3265', '2022-02-06 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3266', '2022-02-06 09:00:05', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3267', '2022-02-06 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3268', '2022-02-06 09:00:06', 'Server Usage Update Failed: Access denied - Server ID: 2', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3269', '2022-02-06 09:00:07', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3270', '2022-02-06 09:00:07', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3271', '2022-02-06 09:00:07', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3272', '2022-02-06 09:00:07', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3273', '2022-02-06 09:00:07', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3274', '2022-02-06 09:00:07', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3275', '2022-02-06 09:00:11', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3276', '2022-02-06 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3277', '2022-02-06 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3278', '2022-02-06 10:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3279', '2022-02-06 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3280', '2022-02-06 14:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3281', '2022-02-06 14:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3282', '2022-02-06 14:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3283', '2022-02-06 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3284', '2022-02-06 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3285', '2022-02-06 18:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3286', '2022-02-06 18:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3287', '2022-02-06 18:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3288', '2022-02-06 22:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3289', '2022-02-06 22:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3290', '2022-02-06 22:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3291', '2022-02-07 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3292', '2022-02-07 01:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3293', '2022-02-07 01:00:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3294', '2022-02-07 02:55:03', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3295', '2022-02-07 02:55:03', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3296', '2022-02-07 02:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3297', '2022-02-07 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3298', '2022-02-07 06:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3299', '2022-02-07 06:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3300', '2022-02-07 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3301', '2022-02-07 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3302', '2022-02-07 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3303', '2022-02-07 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3304', '2022-02-07 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3305', '2022-02-07 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3306', '2022-02-07 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3307', '2022-02-07 09:00:06', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3308', '2022-02-07 09:00:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3309', '2022-02-07 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3310', '2022-02-07 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3311', '2022-02-07 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3312', '2022-02-07 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3313', '2022-02-07 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3314', '2022-02-07 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3315', '2022-02-07 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3316', '2022-02-07 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3317', '2022-02-07 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3318', '2022-02-07 09:00:11', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3319', '2022-02-07 09:00:11', 'Server Usage Update Failed: Access denied - Server ID: 2', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3320', '2022-02-07 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3321', '2022-02-07 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3322', '2022-02-07 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3323', '2022-02-07 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3324', '2022-02-07 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3325', '2022-02-07 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3326', '2022-02-07 09:00:15', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3327', '2022-02-07 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3328', '2022-02-07 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3329', '2022-02-07 10:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3330', '2022-02-07 12:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3331', '2022-02-07 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3332', '2022-02-07 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3333', '2022-02-07 14:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3334', '2022-02-07 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3335', '2022-02-07 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3336', '2022-02-07 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3337', '2022-02-07 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3338', '2022-02-07 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3339', '2022-02-07 22:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3340', '2022-02-07 22:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3341', '2022-02-07 22:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3342', '2022-02-08 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3343', '2022-02-08 01:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3344', '2022-02-08 01:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3345', '2022-02-08 02:39:50', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '180.248.6.6');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3346', '2022-02-08 02:39:52', 'Module Create Failed - Service ID: 4 - Error: Creating the account would exceed the number of licensed users.  Please upgrade your license and try again.', 'rofiq', '1', '0', '1', '180.248.6.6');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3347', '2022-02-08 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3348', '2022-02-08 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3349', '2022-02-08 02:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3350', '2022-02-08 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3351', '2022-02-08 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3352', '2022-02-08 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3353', '2022-02-08 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3354', '2022-02-08 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3355', '2022-02-08 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3356', '2022-02-08 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3357', '2022-02-08 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3358', '2022-02-08 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3359', '2022-02-08 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3360', '2022-02-08 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3361', '2022-02-08 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3362', '2022-02-08 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3363', '2022-02-08 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3364', '2022-02-08 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3365', '2022-02-08 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3366', '2022-02-08 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3367', '2022-02-08 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3368', '2022-02-08 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3369', '2022-02-08 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3370', '2022-02-08 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3371', '2022-02-08 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3372', '2022-02-08 09:00:08', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3373', '2022-02-08 09:00:09', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3374', '2022-02-08 09:00:09', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3375', '2022-02-08 09:00:09', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3376', '2022-02-08 09:00:09', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3377', '2022-02-08 09:00:09', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3378', '2022-02-08 09:00:13', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3379', '2022-02-08 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3380', '2022-02-08 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3381', '2022-02-08 10:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3382', '2022-02-08 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3383', '2022-02-08 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3384', '2022-02-08 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3385', '2022-02-08 14:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3386', '2022-02-08 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3387', '2022-02-08 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3388', '2022-02-08 18:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3389', '2022-02-08 18:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3390', '2022-02-08 18:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3391', '2022-02-08 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3392', '2022-02-08 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3393', '2022-02-08 22:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3394', '2022-02-09 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3395', '2022-02-09 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3396', '2022-02-09 01:00:02', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3397', '2022-02-09 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3398', '2022-02-09 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3399', '2022-02-09 02:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3400', '2022-02-09 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3401', '2022-02-09 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3402', '2022-02-09 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3403', '2022-02-09 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3404', '2022-02-09 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3405', '2022-02-09 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3406', '2022-02-09 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3407', '2022-02-09 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3408', '2022-02-09 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3409', '2022-02-09 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3410', '2022-02-09 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3411', '2022-02-09 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3412', '2022-02-09 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3413', '2022-02-09 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3414', '2022-02-09 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3415', '2022-02-09 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3416', '2022-02-09 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3417', '2022-02-09 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3418', '2022-02-09 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3419', '2022-02-09 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3420', '2022-02-09 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3421', '2022-02-09 09:00:09', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3422', '2022-02-09 09:00:10', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3423', '2022-02-09 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3424', '2022-02-09 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3425', '2022-02-09 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3426', '2022-02-09 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3427', '2022-02-09 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3428', '2022-02-09 09:00:17', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3429', '2022-02-09 10:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3430', '2022-02-09 10:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3431', '2022-02-09 10:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3432', '2022-02-09 12:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3433', '2022-02-09 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3434', '2022-02-09 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3435', '2022-02-09 14:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3436', '2022-02-09 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3437', '2022-02-09 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3438', '2022-02-09 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3439', '2022-02-09 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3440', '2022-02-09 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3441', '2022-02-09 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3442', '2022-02-09 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3443', '2022-02-09 22:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3444', '2022-02-10 00:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3445', '2022-02-10 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3446', '2022-02-10 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3447', '2022-02-10 02:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3448', '2022-02-10 02:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3449', '2022-02-10 02:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3450', '2022-02-10 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3451', '2022-02-10 06:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3452', '2022-02-10 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3453', '2022-02-10 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3454', '2022-02-10 09:00:05', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3455', '2022-02-10 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3456', '2022-02-10 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3457', '2022-02-10 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3458', '2022-02-10 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3459', '2022-02-10 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3460', '2022-02-10 09:00:06', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3461', '2022-02-10 09:00:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3462', '2022-02-10 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3463', '2022-02-10 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3464', '2022-02-10 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3465', '2022-02-10 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3466', '2022-02-10 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3467', '2022-02-10 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3468', '2022-02-10 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3469', '2022-02-10 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3470', '2022-02-10 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3471', '2022-02-10 09:00:07', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3472', '2022-02-10 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3473', '2022-02-10 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3474', '2022-02-10 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3475', '2022-02-10 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3476', '2022-02-10 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3477', '2022-02-10 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3478', '2022-02-10 09:00:15', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3479', '2022-02-10 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3480', '2022-02-10 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3481', '2022-02-10 10:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3482', '2022-02-10 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3483', '2022-02-10 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3484', '2022-02-10 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3485', '2022-02-10 14:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3486', '2022-02-10 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3487', '2022-02-10 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3488', '2022-02-10 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3489', '2022-02-10 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3490', '2022-02-10 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3491', '2022-02-10 22:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3492', '2022-02-10 22:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3493', '2022-02-10 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3494', '2022-02-11 00:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3495', '2022-02-11 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3496', '2022-02-11 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3497', '2022-02-11 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3498', '2022-02-11 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3499', '2022-02-11 02:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3500', '2022-02-11 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3501', '2022-02-11 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3502', '2022-02-11 06:55:09', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3503', '2022-02-11 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3504', '2022-02-11 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3505', '2022-02-11 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3506', '2022-02-11 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3507', '2022-02-11 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3508', '2022-02-11 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3509', '2022-02-11 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3510', '2022-02-11 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3511', '2022-02-11 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3512', '2022-02-11 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3513', '2022-02-11 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3514', '2022-02-11 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3515', '2022-02-11 09:00:05', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3516', '2022-02-11 09:00:05', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3517', '2022-02-11 09:00:05', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3518', '2022-02-11 09:00:05', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3519', '2022-02-11 09:00:05', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3520', '2022-02-11 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3521', '2022-02-11 09:00:09', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3522', '2022-02-11 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3523', '2022-02-11 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3524', '2022-02-11 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3525', '2022-02-11 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3526', '2022-02-11 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3527', '2022-02-11 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3528', '2022-02-11 09:00:14', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3529', '2022-02-11 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3530', '2022-02-11 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3531', '2022-02-11 10:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3532', '2022-02-11 12:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3533', '2022-02-11 14:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3534', '2022-02-11 14:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3535', '2022-02-11 14:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3536', '2022-02-11 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3537', '2022-02-11 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3538', '2022-02-11 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3539', '2022-02-11 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3540', '2022-02-11 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3541', '2022-02-11 22:56:22', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3542', '2022-02-11 22:56:22', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3543', '2022-02-11 22:56:23', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3544', '2022-02-12 00:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3545', '2022-02-12 01:00:05', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3546', '2022-02-12 01:00:05', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3547', '2022-02-12 02:57:48', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3548', '2022-02-12 02:57:48', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3549', '2022-02-12 02:57:49', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3550', '2022-02-12 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3551', '2022-02-12 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3552', '2022-02-12 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3553', '2022-02-12 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3554', '2022-02-12 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3555', '2022-02-12 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3556', '2022-02-12 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3557', '2022-02-12 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3558', '2022-02-12 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3559', '2022-02-12 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3560', '2022-02-12 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3561', '2022-02-12 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3562', '2022-02-12 09:00:10', 'Email Sent to Muhammad Rofiq (Invoice Payment Reminder)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3563', '2022-02-12 09:00:10', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3564', '2022-02-12 09:00:10', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3565', '2022-02-12 09:00:10', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3566', '2022-02-12 09:00:10', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3567', '2022-02-12 09:00:10', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3568', '2022-02-12 09:00:10', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3569', '2022-02-12 09:00:10', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3570', '2022-02-12 09:00:10', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3571', '2022-02-12 09:00:10', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3572', '2022-02-12 09:00:13', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3573', '2022-02-12 09:00:14', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3574', '2022-02-12 09:00:14', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3575', '2022-02-12 09:00:15', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3576', '2022-02-12 09:00:15', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3577', '2022-02-12 09:00:15', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3578', '2022-02-12 09:00:15', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3579', '2022-02-12 09:00:18', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3580', '2022-02-12 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3581', '2022-02-12 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3582', '2022-02-12 10:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3583', '2022-02-12 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3584', '2022-02-12 14:58:53', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3585', '2022-02-12 14:58:53', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3586', '2022-02-12 14:58:54', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3587', '2022-02-12 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3588', '2022-02-12 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3589', '2022-02-12 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3590', '2022-02-12 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3591', '2022-02-12 18:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3592', '2022-02-12 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3593', '2022-02-12 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3594', '2022-02-12 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3595', '2022-02-13 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3596', '2022-02-13 01:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3597', '2022-02-13 01:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3598', '2022-02-13 02:55:30', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3599', '2022-02-13 02:55:30', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3600', '2022-02-13 02:55:31', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3601', '2022-02-13 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3602', '2022-02-13 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3603', '2022-02-13 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3604', '2022-02-13 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3605', '2022-02-13 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3606', '2022-02-13 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3607', '2022-02-13 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3608', '2022-02-13 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3609', '2022-02-13 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3610', '2022-02-13 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3611', '2022-02-13 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3612', '2022-02-13 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3613', '2022-02-13 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3614', '2022-02-13 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3615', '2022-02-13 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3616', '2022-02-13 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3617', '2022-02-13 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3618', '2022-02-13 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3619', '2022-02-13 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3620', '2022-02-13 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3621', '2022-02-13 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3622', '2022-02-13 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3623', '2022-02-13 09:00:07', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3624', '2022-02-13 09:00:07', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3625', '2022-02-13 09:00:07', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3626', '2022-02-13 09:00:07', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3627', '2022-02-13 09:00:07', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3628', '2022-02-13 09:00:08', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3629', '2022-02-13 09:00:11', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3630', '2022-02-13 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3631', '2022-02-13 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3632', '2022-02-13 10:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3633', '2022-02-13 12:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3634', '2022-02-13 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3635', '2022-02-13 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3636', '2022-02-13 14:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3637', '2022-02-13 17:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3638', '2022-02-13 17:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3639', '2022-02-13 18:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3640', '2022-02-13 18:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3641', '2022-02-13 18:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3642', '2022-02-13 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3643', '2022-02-13 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3644', '2022-02-13 22:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3645', '2022-02-14 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3646', '2022-02-14 01:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3647', '2022-02-14 01:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3648', '2022-02-14 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3649', '2022-02-14 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3650', '2022-02-14 02:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3651', '2022-02-14 04:05:28', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3652', '2022-02-14 04:05:34', 'Cron Job: Database Backup requested but backups are not configured.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3653', '2022-02-14 04:08:01', 'General Settings Modified. Changes made: Disable Client Email Preferences Disabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3654', '2022-02-14 04:22:13', 'Automatic Backup Option Activated: Ftp', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3655', '2022-02-14 04:22:14', 'Automatic Backup Settings Changed. FTP Backup Password Changed. FTP Backup Hostname changed from \'\' to \'dev.i3cloud.co.id\'. FTP Backup Username changed from \'\' to \'bak@dev.i3cloud.co.id\'', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3656', '2022-02-14 04:24:52', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3657', '2022-02-14 04:24:52', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3658', '2022-02-14 04:25:03', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3659', '2022-02-14 04:25:03', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3660', '2022-02-14 04:25:04', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3661', '2022-02-14 04:25:04', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3662', '2022-02-14 04:25:04', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3663', '2022-02-14 04:26:05', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3664', '2022-02-14 04:26:05', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3665', '2022-02-14 04:26:16', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3666', '2022-02-14 04:26:16', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3667', '2022-02-14 04:26:17', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3668', '2022-02-14 04:26:17', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3669', '2022-02-14 04:26:17', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3670', '2022-02-14 04:37:45', 'Product Configuration Modified: Apply Tax Enabled. Product ID: 2', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3671', '2022-02-14 04:38:01', 'Product Configuration Modified: Apply Tax Enabled. Product ID: 3', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3672', '2022-02-14 04:38:36', 'Product Configuration Modified: Apply Tax Enabled. Product ID: 4', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3673', '2022-02-14 04:38:46', 'Product Configuration Modified: Apply Tax Enabled. Product ID: 5', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3674', '2022-02-14 05:19:02', 'General Settings Modified. Changes made: Allow Clients Email Opt Out Disabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3675', '2022-02-14 05:20:28', 'General Settings Modified. Changes made: Allow Clients Email Opt Out Enabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3676', '2022-02-14 05:29:11', 'Tax Configuration: Tax EUHome Country No Exempt Enabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3677', '2022-02-14 05:30:11', 'Tax Configuration: Tax EUHome Country No Exempt Disabled.', 'rofiq', '0', '1', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3678', '2022-02-14 05:50:36', 'Addon Module Activated - Email Verification Pro', 'rofiq', '0', '1', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3679', '2022-02-14 05:52:56', 'Addon Module Access Permissions Changed - Email Verification Pro -  Added Role Group(s): Full Administrator.', 'rofiq', '0', '1', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3680', '2022-02-14 05:52:56', 'Addon Module Settings Modified - Email Verification Pro  - Initial setting of Verification type to \'All pages\', Initial setting of Lock Email to \'\', Initial setting of Auto-terminate to \'\', Initial setting of Resend email after to \'7\', Initial setting of Auto-terminate after to \'14\', Initial setting of Users Email Changes to \'on\', Initial setting of Database Table to \'\', License Status: \'cPanelCentral\' to \'\'', 'rofiq', '0', '1', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3681', '2022-02-14 05:53:29', 'General Settings Modified. Changes made: Sequential Invoice Numbering Disabled. Enable Email Verification Disabled.', 'rofiq', '0', '1', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3685', '2022-02-14 05:58:14', 'General Settings Modified. Changes made: Enable Email Verification Enabled.', 'rofiq', '0', '4', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3689', '2022-02-14 05:59:36', 'Email Sent to Muh rof (WHMCS New Order Notification) ', 'rofiq', '0', '4', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3691', '2022-02-14 06:00:10', 'Verification Email Resent', 'rofiq', '0', '4', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3692', '2022-02-14 06:01:45', 'Addon Module Settings Modified - Email Verification Pro  - License Status: \'cPanelCentral\' to \'\'', 'rofiq', '0', '4', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3693', '2022-02-14 06:02:41', 'Client Deleted - ID: 4', 'rofiq', '0', '4', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3697', '2022-02-14 06:10:31', 'Verification Email Resent', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3698', '2022-02-14 06:11:18', 'Verification Email Resent', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3699', '2022-02-14 06:23:23', 'User Account Modified - Email Address changed from \'mrofiq990@gmail.com.oo\' to \'mrofiq990@gmail.com.oo.po\' - UserID: 5', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3700', '2022-02-14 06:23:31', 'Email Modified', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3701', '2022-02-14 06:23:59', 'Verification Email Resent', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3702', '2022-02-14 06:26:31', 'General Settings Modified. Changes made: Enable Email Verification Disabled.', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3703', '2022-02-14 06:26:50', 'Client Deleted - ID: 5', 'rofiq', '0', '5', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3707', '2022-02-14 06:32:07', 'Client Deleted - ID: 6', 'rofiq', '0', '6', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3711', '2022-02-14 06:35:17', 'Client Deleted - ID: 7', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3720', '2022-02-14 06:40:46', 'Client Deleted - ID: 8', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3721', '2022-02-14 06:43:10', 'Addon Module Settings Modified - Email Verification Pro  - Database Table: \'\' to \'on\', License Status: \'cPanelCentral\' to \'\'', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3722', '2022-02-14 06:43:17', 'Addon Module Deactivated - Email Verification Pro', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3723', '2022-02-14 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3724', '2022-02-14 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3725', '2022-02-14 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3726', '2022-02-14 06:57:39', 'General Settings Modified. Changes made: Enable Email Verification Enabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3727', '2022-02-14 07:11:26', 'Product Configuration Modified: Featured Product Enabled. Product ID: 2', 'rofiq', '0', '0', '1', '125.164.234.115');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3728', '2022-02-14 07:54:55', 'Addon Module Activated - Email Verification Pro', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3729', '2022-02-14 07:55:08', 'Addon Module Access Permissions Changed - Email Verification Pro -  Added Role Group(s): Full Administrator.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3730', '2022-02-14 07:55:08', 'Addon Module Settings Modified - Email Verification Pro  - Initial setting of Verification type to \'All pages\', Initial setting of Lock Email to \'\', Initial setting of Auto-terminate to \'on\', Initial setting of Resend email after to \'7\', Initial setting of Auto-terminate after to \'14\', Initial setting of Users Email Changes to \'\', Initial setting of Database Table to \'on\', License Status: \'cPanelCentral\' to \'\'', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3731', '2022-02-14 07:55:42', 'Addon Module Settings Modified - Email Verification Pro  - License Status: \'cPanelCentral\' to \'\'', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3732', '2022-02-14 07:56:35', 'General Settings Modified. Changes made: Enable Email Verification Disabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3733', '2022-02-14 07:59:27', 'Addon Module Settings Modified - Email Verification Pro  - Lock Email: \'\' to \'on\', Users Email Changes: \'\' to \'on\', License Status: \'cPanelCentral\' to \'\'', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3734', '2022-02-14 08:03:13', 'Added Contact - User ID: 2 - Contact ID: 1', 'muhammad.rofiq@i3.co.id', '2', '2', '0', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3738', '2022-02-14 08:43:43', 'Automated Task: Starting Process Email Queue', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3739', '2022-02-14 08:43:43', 'Automated Task: Starting Ticket Escalation Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3751', '2022-02-14 08:55:08', 'Client Deleted - ID: 10', 'rofiq', '0', '0', '1', '180.248.6.6');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3752', '2022-02-14 08:55:19', 'Client Deleted - ID: 11', 'rofiq', '0', '0', '1', '103.144.169.130');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3753', '2022-02-14 08:55:27', 'Client Deleted - ID: 9', 'rofiq', '0', '0', '1', '103.144.169.130');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3754', '2022-02-14 08:57:17', 'Addon Module Deactivated - Email Verification Pro', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3755', '2022-02-14 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3756', '2022-02-14 09:00:05', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3757', '2022-02-14 09:00:06', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3758', '2022-02-14 09:00:06', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3759', '2022-02-14 09:00:06', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3760', '2022-02-14 09:00:06', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3761', '2022-02-14 09:00:06', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3762', '2022-02-14 09:00:06', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3763', '2022-02-14 09:00:06', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3764', '2022-02-14 09:00:07', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3765', '2022-02-14 09:00:07', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3766', '2022-02-14 09:00:07', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3767', '2022-02-14 09:00:07', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3768', '2022-02-14 09:00:07', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3769', '2022-02-14 09:00:07', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3770', '2022-02-14 09:00:07', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3771', '2022-02-14 09:00:07', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3772', '2022-02-14 09:00:07', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3773', '2022-02-14 09:00:09', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3774', '2022-02-14 09:00:11', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3775', '2022-02-14 09:00:11', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3776', '2022-02-14 09:00:11', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3777', '2022-02-14 09:00:11', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3778', '2022-02-14 09:00:11', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3779', '2022-02-14 09:00:11', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3780', '2022-02-14 09:00:15', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3781', '2022-02-14 09:00:15', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3782', '2022-02-14 09:00:27', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3783', '2022-02-14 09:00:27', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3784', '2022-02-14 09:00:28', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3785', '2022-02-14 09:00:28', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3786', '2022-02-14 09:00:28', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3787', '2022-02-14 09:01:33', 'General Settings Modified. Changes made: Enable Email Verification Enabled.', 'rofiq', '0', '0', '1', '182.1.88.106');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3788', '2022-02-14 10:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3789', '2022-02-14 10:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3790', '2022-02-14 10:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3791', '2022-02-14 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3792', '2022-02-14 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3793', '2022-02-14 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3794', '2022-02-14 14:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3795', '2022-02-14 17:00:04', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3796', '2022-02-14 17:00:04', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3797', '2022-02-14 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3798', '2022-02-14 17:00:16', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3799', '2022-02-14 17:00:16', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3800', '2022-02-14 17:00:16', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3801', '2022-02-14 17:00:17', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3802', '2022-02-14 17:00:17', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3803', '2022-02-14 17:00:17', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3804', '2022-02-14 18:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3805', '2022-02-14 18:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3806', '2022-02-14 18:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3807', '2022-02-14 22:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3808', '2022-02-14 22:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3809', '2022-02-14 22:55:05', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3810', '2022-02-15 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3811', '2022-02-15 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3812', '2022-02-15 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3813', '2022-02-15 02:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3814', '2022-02-15 02:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3815', '2022-02-15 02:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3816', '2022-02-15 05:02:30', 'Server Created: \'zero\' - Server ID: 3', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3817', '2022-02-15 05:03:57', 'Server Modified: \'zero\' - Changes: Maximum No. of Accounts Modified: \'200\' to \'50\'. Secondary Nameserver Modified: \'\' to \'ns2.hostercenter.com\' - Server ID: 3', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3818', '2022-02-15 05:04:24', 'Server Modified: \'Server Indonesia\' - Changes: Name Modified: \'zero\' to \'Server Indonesia\' - Server ID: 3', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3819', '2022-02-15 05:05:25', 'Server Modified: \'pandahoster-lama\' - Changes: Name Modified: \'Server Indonesia\' to \'pandahoster-lama\' - Server ID: 2', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3820', '2022-02-15 05:05:43', 'Server Group Modified: \'Server B\' - Changes: Server(s) Added to Group. Server(s) Removed from Group - Server Group ID: 1', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3821', '2022-02-15 05:06:39', 'Running Module Create on Accept Pending Order', 'rofiq', '1', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3822', '2022-02-15 05:06:57', 'Module Create Successful - Service ID: 4', 'rofiq', '1', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3823', '2022-02-15 05:07:08', 'Email Sent to Muhammad Rofiq (New Account Information)  - User ID: 1', 'rofiq', '1', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3824', '2022-02-15 05:07:08', 'Order Accepted - Order ID: 5', 'rofiq', '1', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3825', '2022-02-15 05:07:51', 'Server Modified: \'pandahoster-lama\' - Changes: Maximum No. of Accounts Modified: \'50\' to \'100\' - Server ID: 2', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3826', '2022-02-15 05:08:28', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 2', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3827', '2022-02-15 05:09:07', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 3', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3828', '2022-02-15 05:09:20', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 4', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3829', '2022-02-15 05:09:30', 'Product Configuration Modified: Server Group Modified: \'2\' to \'1\'. Product ID: 5', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3830', '2022-02-15 06:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3831', '2022-02-15 06:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3832', '2022-02-15 06:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3833', '2022-02-15 07:15:46', 'Server Modified: \'Server Indonesia\' - Changes: Maximum No. of Accounts Modified: \'50\' to \'200\' - Server ID: 3', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3834', '2022-02-15 07:16:41', 'Module Terminate Successful - Service ID: 4', 'rofiq', '1', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3835', '2022-02-15 07:16:47', 'Application Link Provisioning returned the following warnings: API failure:   You do not have access to an account named “kjaiilvn”. XIDs: wqqnrv, cmyp47, fpfhws, 9sdsuf, qpsfck and 10 more.', 'rofiq', '0', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3836', '2022-02-15 07:17:15', 'Module Create Successful - Service ID: 4', 'rofiq', '1', '0', '1', '182.1.87.204');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3837', '2022-02-15 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3838', '2022-02-15 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3839', '2022-02-15 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3840', '2022-02-15 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3841', '2022-02-15 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3842', '2022-02-15 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3843', '2022-02-15 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3844', '2022-02-15 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3845', '2022-02-15 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3846', '2022-02-15 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3847', '2022-02-15 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3848', '2022-02-15 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3849', '2022-02-15 09:00:06', 'Cron Job: Suspending Service - Service ID: 4', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3850', '2022-02-15 09:00:08', 'Module Suspend Successful - Service ID: 4', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3851', '2022-02-15 09:00:15', 'Email Sent to Muhammad Rofiq (Service Suspension Notification)  - User ID: 1', 'System', '1', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3852', '2022-02-15 09:00:15', 'Cron Job: SUCCESS: NEWBIE - alwayson247.com - Muhammad Rofiq (Service ID: 4 - User ID: 1)', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3853', '2022-02-15 09:00:15', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3854', '2022-02-15 09:00:15', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3855', '2022-02-15 09:00:15', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3856', '2022-02-15 09:00:15', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3857', '2022-02-15 09:00:15', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3858', '2022-02-15 09:00:16', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3859', '2022-02-15 09:00:19', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3860', '2022-02-15 09:00:21', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3861', '2022-02-15 09:00:21', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3862', '2022-02-15 09:00:21', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3863', '2022-02-15 09:00:21', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3864', '2022-02-15 09:00:21', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3865', '2022-02-15 09:00:21', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3866', '2022-02-15 09:00:24', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3867', '2022-02-15 09:00:24', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3868', '2022-02-15 09:00:38', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3869', '2022-02-15 09:00:38', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3870', '2022-02-15 09:00:38', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3871', '2022-02-15 09:00:38', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3872', '2022-02-15 09:00:38', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3873', '2022-02-15 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3874', '2022-02-15 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3875', '2022-02-15 10:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3876', '2022-02-15 12:55:04', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3877', '2022-02-15 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3878', '2022-02-15 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3879', '2022-02-15 14:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3880', '2022-02-15 17:00:03', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3881', '2022-02-15 17:00:03', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3882', '2022-02-15 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3883', '2022-02-15 17:00:04', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3884', '2022-02-15 17:00:18', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3885', '2022-02-15 17:00:18', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3886', '2022-02-15 17:00:19', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3887', '2022-02-15 17:00:19', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3888', '2022-02-15 17:00:19', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3889', '2022-02-15 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3890', '2022-02-15 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3891', '2022-02-15 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3892', '2022-02-15 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3893', '2022-02-15 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3894', '2022-02-15 22:55:07', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3895', '2022-02-16 00:55:02', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3896', '2022-02-16 01:00:02', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3897', '2022-02-16 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3898', '2022-02-16 02:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3899', '2022-02-16 02:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3900', '2022-02-16 02:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3901', '2022-02-16 06:55:04', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3902', '2022-02-16 06:55:04', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3903', '2022-02-16 06:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3904', '2022-02-16 09:00:02', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3905', '2022-02-16 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3906', '2022-02-16 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3907', '2022-02-16 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3908', '2022-02-16 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3909', '2022-02-16 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3910', '2022-02-16 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3911', '2022-02-16 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3912', '2022-02-16 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3913', '2022-02-16 09:00:05', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3914', '2022-02-16 09:00:05', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3915', '2022-02-16 09:00:05', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3916', '2022-02-16 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3917', '2022-02-16 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3918', '2022-02-16 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3919', '2022-02-16 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3920', '2022-02-16 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3921', '2022-02-16 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3922', '2022-02-16 09:00:06', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3923', '2022-02-16 09:00:08', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3924', '2022-02-16 09:00:08', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3925', '2022-02-16 09:00:08', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3926', '2022-02-16 09:00:08', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3927', '2022-02-16 09:00:08', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3928', '2022-02-16 09:00:08', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3929', '2022-02-16 09:00:12', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3930', '2022-02-16 09:00:12', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3931', '2022-02-16 09:00:25', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3932', '2022-02-16 09:00:25', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3933', '2022-02-16 09:00:25', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3934', '2022-02-16 09:00:26', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3935', '2022-02-16 09:00:26', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3936', '2022-02-16 10:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3937', '2022-02-16 10:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3938', '2022-02-16 10:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3939', '2022-02-16 12:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3940', '2022-02-16 14:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3941', '2022-02-16 14:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3942', '2022-02-16 14:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3943', '2022-02-16 17:00:03', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3944', '2022-02-16 17:00:03', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3945', '2022-02-16 17:00:04', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3946', '2022-02-16 17:00:17', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3947', '2022-02-16 17:00:18', 'Cron Job: Backup Database Dump Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3948', '2022-02-16 17:00:18', 'Cron Job: Starting Backup Zip Creation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3949', '2022-02-16 17:00:18', 'Cron Job: Backup Generation Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3950', '2022-02-16 17:00:18', 'Cron Job: FTP Backup - Completed Successfully', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3951', '2022-02-16 17:00:18', 'Cron Job: Backup Complete', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3952', '2022-02-16 18:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3953', '2022-02-16 18:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3954', '2022-02-16 18:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3955', '2022-02-16 22:55:05', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3956', '2022-02-16 22:55:05', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3957', '2022-02-16 22:55:06', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3958', '2022-02-17 00:55:03', 'Automated Task: Starting Tenant Usage Metrics', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3959', '2022-02-17 01:00:03', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3960', '2022-02-17 01:00:03', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3961', '2022-02-17 02:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3962', '2022-02-17 02:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3963', '2022-02-17 02:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3964', '2022-02-17 06:55:06', 'Automated Task: Starting Domain Transfer Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3965', '2022-02-17 06:55:06', 'Automated Task: Starting Domain Status Synchronisation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3966', '2022-02-17 06:55:08', 'Domain Sync Cron: Completed', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3967', '2022-02-17 09:00:03', 'Cron Job: Starting Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3968', '2022-02-17 09:00:04', 'Automated Task: Starting Currency Exchange Rates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3969', '2022-02-17 09:00:05', 'Updated USD Exchange Rate to 7.0E-5', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3970', '2022-02-17 09:00:05', 'Automated Task: Starting Product Pricing Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3971', '2022-02-17 09:00:05', 'Automated Task: Starting Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3972', '2022-02-17 09:00:05', 'Automated Task: Starting Late Fees', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3973', '2022-02-17 09:00:05', 'Cron Job: Late Invoice Fees added to 0 Invoices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3974', '2022-02-17 09:00:05', 'Automated Task: Starting Credit Card Charges', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3975', '2022-02-17 09:00:05', 'Automated Task: Starting Invoice & Overdue Reminders', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3976', '2022-02-17 09:00:06', 'Automated Task: Starting Domain Renewal Notices', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3977', '2022-02-17 09:00:06', 'Automated Task: Starting Cancellation Requests', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3978', '2022-02-17 09:00:06', 'Automated Task: Starting Overdue Suspensions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3979', '2022-02-17 09:00:06', 'Automated Task: Starting Overdue Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3980', '2022-02-17 09:00:06', 'Automated Task: Starting Fixed Term Terminations', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3981', '2022-02-17 09:00:06', 'Automated Task: Starting Inactive Tickets', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3982', '2022-02-17 09:00:06', 'Automated Task: Starting Delayed Affiliate Commissions', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3983', '2022-02-17 09:00:06', 'Automated Task: Starting Email Marketer Rules', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3984', '2022-02-17 09:00:06', 'Automated Task: Starting SSL Sync', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3985', '2022-02-17 09:00:28', 'Automated Task: Starting Server Usage Stats', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3986', '2022-02-17 09:00:31', 'Automated Task: Starting Client Status Update', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3987', '2022-02-17 09:00:31', 'Automated Task: Starting Domain Expiry', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3988', '2022-02-17 09:00:31', 'Automated Task: Starting Data Retention Pruning', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3989', '2022-02-17 09:00:31', 'Automated Task: Starting WHMCS Updates', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3990', '2022-02-17 09:00:31', 'Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3991', '2022-02-17 09:00:31', 'Cron Job: Completed Daily Automation Tasks', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3992', '2022-02-17 09:00:36', 'Cron Job: Starting Backup Generation', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3993', '2022-02-17 09:00:36', 'Cron Job: Starting Backup Database Dump', 'System', '0', '0', '0', '');
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES ('3994', '2022-02-17 09:00:49', 'Cron Job: Backup Database Dump Complete', 'System', 